% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet_with_cv.R
\name{predict_cv}
\alias{predict_cv}
\title{Predict Function for glmnet_with_cv Models}
\usage{
predict_cv(object, newdata, debias = FALSE, ...)
}
\arguments{
\item{object}{An object returned by \code{\link{glmnet_with_cv}}.}

\item{newdata}{A data frame of new predictor values.}

\item{debias}{Logical; if \code{TRUE}, applies the debiasing linear model stored in
\code{object$debias_fit} (if available). Default is \code{FALSE}.}

\item{...}{Additional arguments (not used).}
}
\value{
A numeric vector of predictions.
}
\description{
Generate predictions from the model fitted by \code{\link{glmnet_with_cv}}. This function accepts
new data and returns predictions, optionally debiased if a debiasing linear model was fit.
}
\details{
Predictions are computed by forming the model matrix from \code{newdata} using the stored \code{formula} and \code{terms}
in the fitted model object. The coefficients used are those stored in \code{parms}. If \code{debias=TRUE} and a
\code{debias_fit} linear model is available, predictions are adjusted by that model.
}
\examples{
set.seed(0)
n <- 50
X1 <- runif(n)
X2 <- runif(n)
y <- 1 + 2*X1 + 3*X2 + rnorm(n)
data <- data.frame(y, X1, X2)
model_cv <- glmnet_with_cv(y ~ X1 + X2, data = data, glmnet_alpha = c(0,0.5,1))
predictions <- predict_cv(model_cv, data)
predictions_debiased <- predict_cv(model_cv, data, debias = TRUE)

}
\seealso{
\code{\link{glmnet_with_cv}}, \code{\link{SVEMnet}}, \code{\link{predict.svem_model}}
}
