% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkcovmat.identity.R
\name{shrinkcovmat.identity}
\alias{shrinkcovmat.identity}
\title{Shrinking the Sample Covariance Matrix Towards the Identity Matrix}
\usage{
shrinkcovmat.identity(data, centered = FALSE)
}
\arguments{
\item{data}{a numeric matrix containing the data.}

\item{centered}{a logical indicating if the mean vector is the zero vector.}
}
\value{
Returns an object of the class 'shrinkcovmathat' that has
components: \item{Sigmahat}{The Stein-type shrinkage estimator of the
covariance matrix.} \item{lambdahat}{The estimated optimal shrinkage
intensity.} \item{Sigmasample}{The sample covariance matrix.}
\item{Target}{The target covariance matrix.} \item{centered}{If the data are
centered around their mean vector.}
}
\description{
Provides a nonparametric Stein-type shrinkage estimator of the covariance
matrix that is a linear combination of the sample covariance matrix and of
the identity matrix.
}
\details{
The rows of the data matrix \code{data} correspond to variables and the
columns to subjects.
}
\examples{
data(colon)
normal_group <- colon[, 1:40]
tumor_group <- colon[, 41:62]
sigma_hat_normal_group <- shrinkcovmat.identity(normal_group)
sigma_hat_normal_group
sigma_hat_tumor_group <- shrinkcovmat.identity(tumor_group)
sigma_hat_tumor_group
}
\references{
Touloumis, A. (2015) nonparametric Stein-type Shrinkage
Covariance Matrix Estimators in High-Dimensional Settings.
\emph{Computational Statistics & Data Analysis} \bold{83}, 251--261.
}
\seealso{
\code{\link{shrinkcovmat.equal}} and
\code{\link{shrinkcovmat.unequal}}.
}
\author{
Anestis Touloumis
}
