% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmcmc.R
\name{pmcmc}
\alias{pmcmc}
\alias{pmcmc,SimInf_model-method}
\title{Particle Markov chain Monte Carlo (PMCMC) algorithm}
\usage{
pmcmc(
  model,
  obs_process,
  data,
  priors,
  n_particles,
  n_iterations,
  theta = NULL,
  covmat = NULL,
  adaptmix = 0.05,
  adaptive = 100,
  post_proposal = NULL,
  init_model = NULL,
  post_particle = NULL,
  chain = NULL,
  verbose = getOption("verbose", FALSE)
)

\S4method{pmcmc}{SimInf_model}(
  model,
  obs_process,
  data,
  priors,
  n_particles,
  n_iterations,
  theta = NULL,
  covmat = NULL,
  adaptmix = 0.05,
  adaptive = 100,
  post_proposal = NULL,
  init_model = NULL,
  post_particle = NULL,
  chain = NULL,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{model}{The model to simulate data from.}

\item{obs_process}{Specification of the stochastic observation
process. The \code{obs_process} can be specified as a
\code{formula} if the model contains only one node and there
is only one data point for each \code{time} in \code{data}.
The left hand side of the formula must match a column name in
the \code{data} data.frame and the right hand side of the
formula is a character specifying the distribution of the
observation process, for example, \code{Iobs ~ poisson(I)}.
The following distributions are supported: \code{x ~
binomial(size, prob)}, \code{x ~ poisson(rate)} and \code{x ~
uniform(min, max)}. The observation process can also be a
function to evaluate the probability density of the
observations given the simulated states. The first argument
passed to the \code{obs_process} function is the result from a
run of the model and it contains one trajectory with simulated
data for a time-point, where the trajectory contains
\code{n_particles} replicates, see
\code{\link{trajectory,SimInf_model-method}}. The second
argument to the \code{obs_process} function is a
\code{data.frame} containing the rows for the specific
time-point that the function is called for. Note that the
function must return the log of the density.}

\item{data}{A \code{data.frame} holding the time series data.}

\item{priors}{The priors for the parameters to fit. Each prior is
specified with a formula notation, for example, \code{beta ~
uniform(0, 1)} specifies that beta is uniformly distributed
between 0 and 1. Use \code{c()} to provide more than one
prior, for example, \code{c(beta ~ uniform(0, 1), gamma ~
normal(10, 1))}. The following distributions are supported:
\code{gamma}, \code{lognormal}, \code{normal} and
\code{uniform}. All parameters in \code{priors} must be only
in either \code{gdata} or \code{ldata}.}

\item{n_particles}{An integer with the number of particles (> 1)
to use at each timestep.}

\item{n_iterations}{An integer specifying the number of iterations
to run the PMCMC.}

\item{theta}{A named vector of initial values for the parameters
of the model.  Default is \code{NULL}, and then these are
sampled from the prior distribution(s).}

\item{covmat}{A named numeric \code{(npars x npars)} matrix with
covariances to use as initial proposal matrix. If left
unspecified then defaults to \code{diag((theta/10)^2/npars)}.}

\item{adaptmix}{Mixing proportion for adaptive proposal.  Must be
a value between zero and one. Default is \code{adaptmix =
0.05}.}

\item{adaptive}{Controls when to start adaptive update. Must be
greater or equal to zero. If \code{adaptive=0}, then adaptive
update is not performed. Default is \code{adaptive = 100}.}

\item{post_proposal}{An optional function that, if
non-\code{NULL}, is applied on the model after the proposal
has been set for the model, but before running the particle
filter. The function must accept one argument of type
\code{SimInf_model} with the current model of the fitting
process. This function can be useful to update, for example,
\code{ldata} of the model before running a trajectory with
proposed parameters. The function must return the model object
which is then used in the particle filter.}

\item{init_model}{An optional function that, if non-NULL, is
applied in the particle filter before running each
proposal. The function must accept one argument of type
\code{SimInf_model} with the current model of the fitting
process. This function can be useful to specify the initial
state of \code{u0} or \code{v0} of the model before running a
trajectory with proposed parameters.}

\item{post_particle}{An optional function that, if non-NULL, is
applied after each completed particle. The function must
accept three arguments: 1) an object of \code{SimInf_pmcmc}
with the current state of the fitting process, 2) an object
\code{SimInf_pfilter} with the last particle and one filtered
trajectory attached, and 3) an integer with the iteration in
the fitting process. This function can be useful to, for
example, monitor, save and inspect intermediate results. Note
that the second \code{SimInf_pfilter} argument, is non-NULL
only for the first particle in the chain, and for accepted
particles.}

\item{chain}{An optional chain to start from. Must be a
\code{data.frame} or an object that can be coerced to a
\code{data.frame}. Only the columns in \code{chain} with a
name that matches the names that will be used if this argument
is not provided will be used. When this argument is provided,
\code{n_iterations} can be 0. Additionally, when the
\code{chain} argument is provided, then \code{theta} and
\code{covmat} must be \code{NULL}.}

\item{verbose}{prints diagnostic messages when \code{TRUE}. The
default is to retrieve the global option \code{verbose} and
use \code{FALSE} if it is not set. When \code{verbose=TRUE},
information is printed every 100 iterations. For pmcmc, it is
possible to get information every nth information by
specifying \code{verbose=n}, for example, \code{verbose=1} or
\code{verbose=10}.}
}
\description{
Particle Markov chain Monte Carlo (PMCMC) algorithm
}
\references{
\Andrieu2010

\Roberts2009
}
\seealso{
\code{\link{continue_pmcmc}}.
}
