% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPC_TFM.R
\name{OPC_TFM}
\alias{OPC_TFM}
\title{Apply the OPC method to the Truncated factor model}
\usage{
OPC_TFM(data, m = m, A, D, p)
}
\arguments{
\item{data}{A matrix of input data.}

\item{m}{The number of principal components.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}

\item{p}{The number of variables.}
}
\value{
A list containing:
\item{Ao}{Estimated factor loadings.}
\item{Do}{Estimated uniquenesses.}
\item{MSEA}{Mean squared error for factor loadings.}
\item{MSED}{Mean squared error for uniquenesses.}
\item{tau}{The sparsity.}
}
\description{
This function computes Online Principal Component Analysis (OPC) for the provided input data, estimating factor loadings and uniquenesses. It calculates mean squared errors and sparsity for the estimated values compared to true values.
}
\examples{
\dontrun{
library(SOPC)
library(relliptical)
library(MASS)
results <- OPC_TFM(data, m, A, D, p)
print(results)}
}
