% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_two_proportions.R
\name{power_twoprop}
\alias{power_twoprop}
\alias{powerTOSTtwo.prop}
\title{TOST Power for Tests of Two Proportions}
\usage{
powerTOSTtwo.prop(
  alpha,
  statistical_power,
  prop1,
  prop2,
  N,
  low_eqbound_prop,
  high_eqbound_prop
)

power_twoprop(
  p1,
  p2,
  n = NULL,
  null = 0,
  alpha = NULL,
  power = NULL,
  alternative = c("two.sided", "one.sided", "equivalence")
)
}
\arguments{
\item{alpha}{a priori alpha-level (i.e., significance level).}

\item{statistical_power}{Deprecated. desired power (e.g., 0.8)}

\item{prop1}{Deprecated. expected proportion in group 1.}

\item{prop2}{Deprecated. expected proportion in group 2.}

\item{N}{Deprecated. sample size (e.g., 108)}

\item{low_eqbound_prop}{Deprecated. lower equivalence bounds (e.g., -0.05) expressed in proportion}

\item{high_eqbound_prop}{Deprecated. upper equivalence bounds (e.g., 0.05) expressed in proportion}

\item{p1, p2}{Proportions in each respective group.}

\item{n}{Sample size per group.}

\item{null}{the null hypothesis value.}

\item{power}{statistical power (1-beta).}

\item{alternative}{equivalence, one-sided, or two-sided test. Can be abbreviated.}
}
\value{
Calculate either achieved power, equivalence bounds, or required N, assuming a true effect size of 0.
Returns a string summarizing the power analysis, and a numeric variable for number of observations, equivalence bounds, or power.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Power analysis for TOST for difference between two proportions using Z-test (pooled)
}
\examples{
## Sample size for alpha = 0.05, 90\% power, assuming true effect prop1 = prop 2 = 0.5,
## equivalence bounds of 0.4 and 0.6 (so low_eqbound_prop = -0.1 and high_eqbound_prop = 0.1)

#powerTOSTtwo.prop(alpha = 0.05, statistical_power = 0.9, prop1 = 0.5, prop2 = 0.5,
#    low_eqbound_prop = -0.1, high_eqbound_prop = 0.1)

   power_twoprop(alpha = 0.05, power = 0.9, p1 = 0.5, p2 = 0.5,
   null = 0.1, alternative = "e")

## Power for alpha = 0.05, N 542 , assuming true effect prop1 = prop 2 = 0.5,
## equivalence bounds of 0.4 and 0.6 (so low_eqbound_prop = -0.1 and high_eqbound_prop = 0.1)

#powerTOSTtwo.prop(alpha = 0.05, N = 542, prop1 = 0.5, prop2 = 0.5,
#    low_eqbound_prop = -0.1, high_eqbound_prop = 0.1)

power_twoprop(alpha = 0.05, n = 542, p1 = 0.5, p2 = 0.5,
   null = 0.1, alternative = "e")


#Example 4.2.4 from Chow, Wang, & Shao (2007, p. 93)
#powerTOSTtwo.prop(alpha=0.05, statistical_power=0.8, prop1 = 0.75, prop2 = 0.8,
#    low_eqbound_prop = -0.2, high_eqbound_prop = 0.2)

power_twoprop(alpha = 0.05, power = 0.8, p1 = 0.75, p2 = 0.8,
   null = 0.2, alternative = "e")

# Example 5 from Julious & Campbell (2012, p. 2932)
#powerTOSTtwo.prop(alpha=0.025, statistical_power=0.9, prop1 = 0.8, prop2 = 0.8,
#    low_eqbound_prop=-0.1, high_eqbound_prop=0.1)
 power_twoprop(alpha = 0.025, power = 0.9, p1 = 0.8, p2 = 0.8,
   null = 0.1, alternative = "e")
# From Machin, D. (Ed.). (2008). Sample size tables for clinical studies (3rd ed).

# Example 9.4b equivalence of two proportions (p. 113) #
# powerTOSTtwo.prop(alpha=0.010, statistical_power=0.8, prop1 = 0.5, prop2 = 0.5,
#    low_eqbound_prop = -0.2, high_eqbound_prop = 0.2)/2
power_twoprop(alpha = 0.01, power = 0.8, p1 = 0.5, p2 = 0.5,
   null = 0.2, alternative = "e")
}
\references{
Silva, G. T. da, Logan, B. R., & Klein, J. P. (2008). Methods for Equivalence and Noninferiority Testing. Biology of Blood and Marrow Transplantation: Journal of the American Society for Blood and Marrow Transplantation, 15(1 Suppl), 120-127. https://doi.org/10.1016/j.bbmt.2008.10.004

Julious, S. A. & Campell, M. J. (2012). Tutorial in biostatistics: sample sizes for parallel group clinical trials with binary data. Statistics in Medicine, 31:2904-2936.

Chow, S.-C., Wang, H., & Shao, J. (2007). Sample Size Calculations in Clinical Research, Second Edition (2 edition). Boca Raton: Chapman and Hall/CRC.
}
