% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{sapply64}
\alias{sapply64}
\alias{vapply64}
\alias{replicate64}
\title{Apply a function that returns 64-bit integers over a list or vector}
\usage{
sapply64(X, FUN, ..., simplify = TRUE, USE.NAMES = TRUE)

vapply64(X, FUN, FUN.LEN = 1, ...)

replicate64(n, expr, simplify = "array")
}
\arguments{
\item{X}{a vector (atomic or list) or an \code{\link[base]{expression}}
    object.  Other objects (including classed objects) will be coerced
    by \code{base::\link[base]{as.list}}.}

\item{FUN}{the function to be applied to each element of \code{X}:
    see \sQuote{Details}.  In the case of functions like
    \code{+}, \code{\%*\%}, the function name must be backquoted or quoted.}

\item{...}{optional arguments to \code{FUN}.}

\item{simplify}{logical or character string; should the result be
    simplified to a vector, matrix or higher dimensional array if
    possible?  For \code{sapply} it must be named and not abbreviated.
    The default value, \code{TRUE}, returns a vector or matrix if appropriate,
    whereas if \code{simplify = "array"} the result may be an
    \code{\link[base]{array}} of \dQuote{rank}
    (\eqn{=}\code{length(dim(.))}) one higher than the result
    of \code{FUN(X[[i]])}.}

\item{USE.NAMES}{logical; if \code{TRUE} and if \code{X} is character,
    use \code{X} as \code{\link[base]{names}} for the result unless it had names
    already.  Since this argument follows \code{\dots} its name cannot
    be abbreviated.}

\item{FUN.LEN}{Integer specifying the length of the output of \code{FUN}.}

\item{n}{integer: the number of replications.}

\item{expr}{the expression (a \link[base]{language object}, usually a call)
    to evaluate repeatedly.}
}
\description{
Wrappers for members of the \code{\link[=lapply]{lapply()}} family intended for use when a
function \code{FUN} returns a vector of \code{integer64} objects.
\code{vapply()}, \code{sapply()} or \code{replicate()} drop the \code{integer64} class,
resulting in a vector of numerics that require conversion back to
64-bit integers.  These functions restore the missing \code{class} attribute.
}
\details{
For details of the underlying functions, see \code{\link[base:lapply]{base::lapply()}}.
}
\examples{
sapply64(as.phylo(1:6, 6), as.TreeNumber)
vapply64(as.phylo(1:6, 6), as.TreeNumber, 1)
set.seed(0)
replicate64(6, as.TreeNumber(RandomTree(6)))
}
\seealso{
\code{\link[bit64]{integer64}()}

Other utility functions: 
\code{\link{ClusterTable}},
\code{\link{ClusterTable-methods}},
\code{\link{Hamming}()},
\code{\link{MSTEdges}()},
\code{\link{SampleOne}()},
\code{\link{TipTimedTree}()},
\code{\link{UnshiftTree}()},
\code{\link{as.multiPhylo}()},
\code{\link{match,phylo,phylo-method}},
\code{\link{sort.multiPhylo}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{utility functions}
