% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_projection_plots.R
\name{create_projection_plots}
\alias{create_projection_plots}
\title{Create Projection Visualization Plots}
\usage{
create_projection_plots(
  data,
  class_column = NULL,
  alternative_class_column = NULL,
  coordinate_columns = NULL,
  case_labels = NULL,
  coord_names = c("Dim1", "Dim2"),
  title = NULL,
  show_labels = FALSE,
  ellipse_alpha = 0.1,
  voronoi_alpha = 0.3,
  point_size = 2,
  legend_position = "bottom",
  color_palette = NULL,
  add_grid_lines = FALSE,
  color_points = "primary",
  fill_voronoi = "primary",
  point_shape = "none",
  label_fontface = "plain",
  label_size = 3.88
)
}
\arguments{
\item{data}{A data frame containing projected data. Must have at least 2 numeric columns.
If more than 2 columns are provided, the first 2 are used as coordinates.}

\item{class_column}{Character string specifying the column name containing class labels,
or a vector of class labels. If NULL, all observations are treated as a single class.
Default: NULL.}

\item{alternative_class_column}{Character string specifying the column name containing
alternative class labels, or a vector of alternative class labels. If NULL, uses
class_column. Default: NULL.}

\item{coordinate_columns}{Character vector of length 2 specifying the column names
to use as coordinates. If NULL, uses the first two numeric columns. Default: NULL.}

\item{case_labels}{Character vector of case labels for individual observations.
If NULL, row numbers are used. Default: NULL.}

\item{coord_names}{Character vector of length 2 specifying names for the coordinate axes.
Default: c("Dim1", "Dim2").}

\item{title}{Character string for plot title. If NULL, no title is added. Default: NULL.}

\item{show_labels}{Logical indicating whether to show case labels on plots. Default: FALSE.}

\item{ellipse_alpha}{Numeric value (0-1) for ellipse transparency. Default: 0.1.}

\item{voronoi_alpha}{Numeric value (0-1) for Voronoi polygon transparency. Default: 0.3.}

\item{point_size}{Numeric value for point size. Default: 2.}

\item{legend_position}{Character string or numeric vector specifying legend position.
Default: "bottom".}

\item{color_palette}{Function or character vector for color palette. If NULL, uses
ggplot2 default colors. Default: NULL.}

\item{add_grid_lines}{Logical indicating whether to add dashed grid lines at origin.
Default: FALSE.}

\item{color_points}{Character string specifying which classification to use for point colors.
Either "primary" (uses class_column) or "alternative" (uses alternative_class_column).
Default: "primary".}

\item{fill_voronoi}{Character string specifying which classification to use for Voronoi fill.
Either "primary" (uses class_column) or "alternative" (uses alternative_class_column).
Default: "primary".}

\item{point_shape}{Character string specifying which classification to use for point shapes.
Either "primary" (uses class_column), "alternative" (uses alternative_class_column),
or "none" (no shape differentiation). Default: "none".}

\item{label_fontface}{Character string specifying the font face for text labels.
Options include "plain", "bold", "italic", "bold.italic". Default: "plain".}

\item{label_size}{Numeric value specifying the size of text labels. Default: 3.88.}
}
\value{
A list containing three ggplot objects:
\item{ellipse_plot}{Plot with confidence ellipses for each class}
\item{voronoi_plot}{Plot with Voronoi tessellation regions}
\item{voronoi_plot_plus_ellipse}{Combined plot with both Voronoi regions and ellipses}
}
\description{
Creates three types of visualization plots for 2D projected data: ellipse plots,
Voronoi diagram plots, and combined ellipse-Voronoi plots. The function is designed
to visualize class separation in dimensionally reduced data.
}
\details{
The function creates visualizations for 2D projected data, particularly useful
for displaying results from dimensionality reduction techniques like PCA, PLS-DA, or t-SNE.

Voronoi tessellation divides the plot space into regions based on proximity to data points,
providing an intuitive visualization of class boundaries and decision regions.

Confidence ellipses show the distribution spread and correlation structure within each class.
}
\examples{
# Basic usage with iris dataset
data <- iris[, c("Sepal.Length", "Petal.Length", "Species")]
plots <- create_projection_plots(
  data = data,
  class_column = "Species",
  legend_position = "bottom",
  add_grid_lines = FALSE
)

}