% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotZFunction.R
\name{PlotZFunction}
\alias{PlotZFunction}
\title{Plot input and output for the Zadeh's principle}
\usage{
PlotZFunction(
  value,
  FUN,
  knots = 10,
  grid = TRUE,
  alternate = FALSE,
  approximation = FALSE,
  method = "NearestEuclidean",
  ...
)
}
\arguments{
\item{value}{Input fuzzy number.}

\item{FUN}{Function used for the input fuzzy number with the help of the Zadeh's principle.}

\item{knots}{Number of the alpha-cuts used during calculation of the output.}

\item{grid}{If \code{TRUE}, then additional grid is plotted.}

\item{alternate}{If \code{TRUE}, the second type of the layout of figures is used.}

\item{approximation}{If \code{TRUE}, the approximated output is calculated.}

\item{method}{The selected approximation method.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
Three (or four) figures are plotted: the input fuzzy number, the respective output (for the Zadeh's principle
and the applied function), and the function. The output fuzzy number can be approximated with the
selected method and also plotted.
}
\description{
\code{PlotZFunction} applies the selected function to a fuzzy number using the Zadeh's principle, and plots
the input and output.
}
\details{
The function takes the input fuzzy number \code{value} (which should be described by one of the
classes from \code{FuzzyNumbers} package) and applies the function \code{FUN} using
the Zadeh's principle. The output is given by a fuzzy number or its approximation (when
\code{approximation} is set to \code{TRUE} and the respective \code{method} is selected).
To properly find the output, value of \code{FUN} is calculated for many alpha-cuts of \code{value}.
The number of these alpha-cuts is equal to \code{knots} (plus 2 for the support and the core).
The input and output fuzzy numbers are plotted together with the applied function.
If the approximation is used, then also the approximated fuzzy number is shown (green line).

The input fuzzy number \code{value} should be given by fuzzy number described by classes from \code{FuzzyNumbers} package.
}
\examples{

library(FuzzyNumbers)

# prepare complex fuzzy number

A <- FuzzyNumber(-5, 3, 6, 20, left=function(x)
pbeta(x,0.4,3),
right=function(x) 1-x^(1/4),
lower=function(alpha) qbeta(alpha,0.4,3),
upper=function(alpha) (1-alpha)^4)

# plot the figures

PlotZFunction(A,FUN=function(x)x^3+2*x^2-1)

# find and plot the approximated output via the Zadeh's principle

PlotZFunction(A,FUN=function(x)x^3+2*x^2-1,approximation=TRUE)


}
