% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmdata.R
\name{afmdata}
\alias{afmdata}
\title{AFM data}
\usage{
afmdata(data, dstr = "Z", Fstr = "Force", Segstr = "Segment", tstr = "Time", 
 params = list(SpringConstant = numeric(), curvename = NULL ))
}
\arguments{
\item{data}{A data frame consisting in 3 or 4 columns. A minimum of "Z" (or "distance"),
"Force" and "Segment". Optionally a fourth column with "Time" could be added.}

\item{dstr}{Character string with the posible names for the distance variable.}

\item{Fstr}{Character string with the posible names for the force variable.}

\item{Segstr}{Character string with the posible names for the Segment variable.}

\item{tstr}{Character string with the posible names for the time variable.}

\item{params}{A list that may contain parameters describing the F-d curve. At least will
contain the \code{SpringConstant} and the \code{curvename}, being the former the
cantilever spring constant and the latter  a F-d curve ID. Function \code{afmReadJPK}
will try to obtain the spring constant from the file header and the curvename from the
data file name.}
}
\value{
An object of class \code{afmdata}
}
\description{
This function creates an \code{afmdata} structure, which is as list with at
least one field called \code{data} which is a data frame with a valid AFM data, that is,
at least 3 variables called "Z", "Force", and "Segment".
}
\examples{
#Making some artifical data following a L-J 12-6 potential
n <- 1000
z <- seq(from = 9e-3, to = 1e-1, length.out = n )
u0 <- 1e-5
z0 <- 1e-2
Force <- -u0*(12*z0^6/z^7-12*z0^12/z^13)
Segment <- rep("approach",n)
AFMcurve <- afmdata(data.frame(Z = z, Force = Force, Segment  = Segment))
plot(AFMcurve)
}
\seealso{
\code{\link{afmexperiment}}
}

