% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_test_that.R
\name{generate_args_for_tests}
\alias{generate_args_for_tests}
\title{Generate combinations of arguments}
\usage{
generate_args_for_tests(
  object_name,
  method,
  var_objects = list(),
  necessary_objects = list(),
  var_override = list(sustain_interval = 30, trace = FALSE, epochs = 50, batch_size = 20,
    ml_trace = 0, n_cores = 2, data_folds = 2, pl_max_steps = 2, pl_max = 1, pl_anchor =
    1, pl_min = 0, sustain_track = TRUE, sustain_iso_code = "DEU", data_val_size = 0.25,
    lr_rate = 0.001, lr_warm_up_ratio = 0.01)
)
}
\arguments{
\item{object_name}{\code{string} Name of the object to generate the arguments for.}

\item{method}{\code{string} Name of the method of the object to generate the arguments for.}

\item{var_objects}{\code{list} of other objects which should be combined with the other arguments.}

\item{necessary_objects}{\code{list} of other objects which are part of every combination.}

\item{var_override}{Named \code{list} containing the arguments which should be set to a specific value
for all combinations.}
}
\value{
Returns a \code{list} with combinations of arguments.
}
\description{
Function generates a specific number of combinations for a method.
These are used for automating tests of objects.
}
\note{
\code{var_objects}, \code{necessary_objects}, and \code{var_override} the names must exactly match
the name of the parameter. Otherwise they are not applied. Names of arguments which are not part
a a method are ignored. #'
}
\seealso{
Other Utils TestThat Developers: 
\code{\link{check_adjust_n_samples_on_CI}()},
\code{\link{generate_embeddings}()},
\code{\link{generate_tensors}()},
\code{\link{get_current_args_for_print}()},
\code{\link{get_fixed_test_tensor}()},
\code{\link{get_test_data_for_classifiers}()},
\code{\link{random_bool_on_CI}()}
}
\concept{Utils TestThat Developers}
