% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_TEClassifiersBasedOnProtoNet.R
\name{TEClassifiersBasedOnProtoNet}
\alias{TEClassifiersBasedOnProtoNet}
\title{Base class for classifiers relying on numerical representations of texts instead of words that use
the architecture of Protonets and its corresponding training techniques.}
\value{
A new object of this class.
}
\description{
Base class for classifiers relying on \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} as input
which use the architecture of Protonets and its corresponding training techniques.

Objects of this class containing fields and methods used in several other classes in 'AI for Education'.

This class is \strong{not} designed for a direct application and should only be used by developers.
}
\seealso{
Other R6 Classes for Developers: 
\code{\link{AIFEBaseModel}},
\code{\link{ClassifiersBasedOnTextEmbeddings}},
\code{\link{LargeDataSetBase}},
\code{\link{ModelsBasedOnTextEmbeddings}},
\code{\link{TEClassifiersBasedOnRegular}}
}
\concept{R6 Classes for Developers}
\section{Super classes}{
\code{\link[aifeducation:AIFEBaseModel]{aifeducation::AIFEBaseModel}} -> \code{\link[aifeducation:ModelsBasedOnTextEmbeddings]{aifeducation::ModelsBasedOnTextEmbeddings}} -> \code{\link[aifeducation:ClassifiersBasedOnTextEmbeddings]{aifeducation::ClassifiersBasedOnTextEmbeddings}} -> \code{TEClassifiersBasedOnProtoNet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TEClassifiersBasedOnProtoNet-train}{\code{TEClassifiersBasedOnProtoNet$train()}}
\item \href{#method-TEClassifiersBasedOnProtoNet-predict_with_samples}{\code{TEClassifiersBasedOnProtoNet$predict_with_samples()}}
\item \href{#method-TEClassifiersBasedOnProtoNet-embed}{\code{TEClassifiersBasedOnProtoNet$embed()}}
\item \href{#method-TEClassifiersBasedOnProtoNet-get_metric_scale_factor}{\code{TEClassifiersBasedOnProtoNet$get_metric_scale_factor()}}
\item \href{#method-TEClassifiersBasedOnProtoNet-plot_embeddings}{\code{TEClassifiersBasedOnProtoNet$plot_embeddings()}}
\item \href{#method-TEClassifiersBasedOnProtoNet-clone}{\code{TEClassifiersBasedOnProtoNet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="count_parameter"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-count_parameter'><code>aifeducation::AIFEBaseModel$count_parameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_all_fields"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_all_fields'><code>aifeducation::AIFEBaseModel$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_documentation_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_documentation_license'><code>aifeducation::AIFEBaseModel$get_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_ml_framework"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_ml_framework'><code>aifeducation::AIFEBaseModel$get_ml_framework()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_description"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_description'><code>aifeducation::AIFEBaseModel$get_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_info'><code>aifeducation::AIFEBaseModel$get_model_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_license'><code>aifeducation::AIFEBaseModel$get_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_package_versions"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_package_versions'><code>aifeducation::AIFEBaseModel$get_package_versions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_private"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_private'><code>aifeducation::AIFEBaseModel$get_private()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_publication_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_publication_info'><code>aifeducation::AIFEBaseModel$get_publication_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_sustainability_data"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_sustainability_data'><code>aifeducation::AIFEBaseModel$get_sustainability_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="is_configured"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-is_configured'><code>aifeducation::AIFEBaseModel$is_configured()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="is_trained"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-is_trained'><code>aifeducation::AIFEBaseModel$is_trained()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="load"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-load'><code>aifeducation::AIFEBaseModel$load()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_documentation_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_documentation_license'><code>aifeducation::AIFEBaseModel$set_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_model_description"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_model_description'><code>aifeducation::AIFEBaseModel$set_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_model_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_model_license'><code>aifeducation::AIFEBaseModel$set_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_publication_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_publication_info'><code>aifeducation::AIFEBaseModel$set_publication_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ModelsBasedOnTextEmbeddings" data-id="get_text_embedding_model"><a href='../../aifeducation/html/ModelsBasedOnTextEmbeddings.html#method-ModelsBasedOnTextEmbeddings-get_text_embedding_model'><code>aifeducation::ModelsBasedOnTextEmbeddings$get_text_embedding_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ModelsBasedOnTextEmbeddings" data-id="get_text_embedding_model_name"><a href='../../aifeducation/html/ModelsBasedOnTextEmbeddings.html#method-ModelsBasedOnTextEmbeddings-get_text_embedding_model_name'><code>aifeducation::ModelsBasedOnTextEmbeddings$get_text_embedding_model_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="adjust_target_levels"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-adjust_target_levels'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$adjust_target_levels()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="check_embedding_model"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-check_embedding_model'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$check_embedding_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="check_feature_extractor_object_type"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-check_feature_extractor_object_type'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$check_feature_extractor_object_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="load_from_disk"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-load_from_disk'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$load_from_disk()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="plot_coding_stream"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-plot_coding_stream'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$plot_coding_stream()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="plot_training_history"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-plot_training_history'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$plot_training_history()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="predict"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-predict'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="requires_compression"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-requires_compression'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$requires_compression()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="ClassifiersBasedOnTextEmbeddings" data-id="save"><a href='../../aifeducation/html/ClassifiersBasedOnTextEmbeddings.html#method-ClassifiersBasedOnTextEmbeddings-save'><code>aifeducation::ClassifiersBasedOnTextEmbeddings$save()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifiersBasedOnProtoNet-train"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifiersBasedOnProtoNet-train}{}}}
\subsection{Method \code{train()}}{
Method for training a neural net.

Training includes a routine for early stopping. In the case that loss<0.0001 and Accuracy=1.00 and Average
Iota=1.00 training stops. The history uses the values of the last trained epoch for the remaining epochs.

After training the model with the best values for Average Iota, Accuracy, and Loss on the validation data set
is used as the final model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifiersBasedOnProtoNet$train(
  data_embeddings = NULL,
  data_targets = NULL,
  data_folds = 5,
  data_val_size = 0.25,
  loss_pt_fct_name = "MultiWayContrastiveLoss",
  use_sc = FALSE,
  sc_method = "knnor",
  sc_min_k = 1,
  sc_max_k = 10,
  use_pl = FALSE,
  pl_max_steps = 3,
  pl_max = 1,
  pl_anchor = 1,
  pl_min = 0,
  sustain_track = TRUE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  epochs = 40,
  batch_size = 35,
  Ns = 5,
  Nq = 3,
  loss_alpha = 0.5,
  loss_margin = 0.05,
  sampling_separate = FALSE,
  sampling_shuffle = TRUE,
  trace = TRUE,
  ml_trace = 1,
  log_dir = NULL,
  log_write_interval = 10,
  n_cores = auto_n_cores(),
  lr_rate = 0.001,
  lr_warm_up_ratio = 0.02,
  optimizer = "AdamW"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_embeddings}}{\verb{EmbeddedText, LargeDataSetForTextEmbeddings} Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}.}

\item{\code{data_targets}}{\code{factor} containing the labels for cases stored in embeddings. Factor must be
named and has to use the same names as used in in the embeddings. .}

\item{\code{data_folds}}{\code{int} determining the number of cross-fold samples. Allowed values: \code{1 <= x }}

\item{\code{data_val_size}}{\code{double} between 0 and 1, indicating the proportion of cases which should be
used for the validation sample during the estimation of the model.
The remaining cases are part of the training data. Allowed values: \verb{0 < x < 1}}

\item{\code{loss_pt_fct_name}}{\code{string} Name of the loss function to use during training. Allowed values: 'MultiWayContrastiveLoss'}

\item{\code{use_sc}}{\code{bool} \code{TRUE} if the estimation should integrate synthetic cases. \code{FALSE} if not.}

\item{\code{sc_method}}{\code{string} containing the method for generating synthetic cases. Allowed values: 'knnor'}

\item{\code{sc_min_k}}{\code{int} determining the minimal number of k which is used for creating synthetic units. Allowed values: \code{1 <= x }}

\item{\code{sc_max_k}}{\code{int} determining the maximal number of k which is used for creating synthetic units. Allowed values: \code{1 <= x }}

\item{\code{use_pl}}{\code{bool} \code{TRUE} if the estimation should integrate pseudo-labeling. \code{FALSE} if not.}

\item{\code{pl_max_steps}}{\code{int} determining the maximum number of steps during pseudo-labeling. Allowed values: \code{1 <= x }}

\item{\code{pl_max}}{\code{double} setting the maximal level of confidence for considering a case for pseudo-labeling. Allowed values: \verb{0 < x <= 1}}

\item{\code{pl_anchor}}{\code{double} indicating the reference point for sorting the new cases of every label. Allowed values: \verb{0 <= x <= 1}}

\item{\code{pl_min}}{\code{double} setting the mnimal level of confidence for considering a case for pseudo-labeling. Allowed values: \verb{0 <= x < 1}}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library 'codecarbon'.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if
sustainability should be tracked. A list can be found on Wikipedia:
\url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}. Allowed values: any}

\item{\code{sustain_region}}{\code{string} Region within a country. Only available for USA and Canada See the documentation of
codecarbon for more information. \url{https://mlco2.github.io/codecarbon/parameters.html} Allowed values: any}

\item{\code{sustain_interval}}{\code{int} Interval in seconds for measuring power usage. Allowed values: \code{1 <= x }}

\item{\code{epochs}}{\code{int} Number of training epochs. Allowed values: \code{1 <= x }}

\item{\code{batch_size}}{\code{int} Size of the batches for training. Allowed values: \code{1 <= x }}

\item{\code{Ns}}{\code{int} Number of cases for every class in the sample. Allowed values: \code{1 <= x }}

\item{\code{Nq}}{\code{int} Number of cases for every class in the query. Allowed values: \code{1 <= x }}

\item{\code{loss_alpha}}{\code{double} Value between 0 and 1 indicating how strong the loss should focus on pulling cases to
its corresponding prototypes or pushing cases away from other prototypes. The higher the value the more the
loss concentrates on pulling cases to its corresponding prototypes. Allowed values: \verb{0 <= x <= 1}}

\item{\code{loss_margin}}{\code{double} Value greater 0 indicating the minimal distance of every case from prototypes of other classes. Please note that
in contrast to the orginal work by Zhang et al. (2019) this implementation
reaches better performance if the margin is a magnitude lower (e.g. 0.05 instead of 0.5). Allowed values: \verb{0 <= x <= 1}}

\item{\code{sampling_separate}}{\code{bool} If \code{TRUE} the cases for every class are divided into a data set for sample and
for query. These are never mixed. If \code{TRUE} sample and query cases are drawn from the same data pool. That is,
a case can be part of sample in one epoch and in another epoch it can be part of query. It is ensured that a
case is never part of sample and query at the same time. In addition, it is ensured that every cases exists
only once during a training step.}

\item{\code{sampling_shuffle}}{\code{bool} if \code{TRUE} cases a randomly drawn from the data during every step. If \code{FALSE} the
cases are not shuffled.}

\item{\code{trace}}{\code{bool} \code{TRUE} if information about the estimation phase should be printed to the console.}

\item{\code{ml_trace}}{\code{int} \code{ml_trace=0} does not print any information about the training process from pytorch on the console. Allowed values: \verb{0 <= x <= 1}}

\item{\code{log_dir}}{\code{string} Path to the directory where the log files should be saved.
If no logging is desired set this argument to \code{NULL}. Allowed values: any}

\item{\code{log_write_interval}}{\code{int} Time in seconds determining the interval in which the logger should try to update
the log files. Only relevant if \code{log_dir} is not \code{NULL}. Allowed values: \code{1 <= x }}

\item{\code{n_cores}}{\code{int} Number of cores which should be used during the calculation of synthetic cases. Only relevant if \code{use_sc=TRUE}. Allowed values: \code{1 <= x }}

\item{\code{lr_rate}}{\code{double} Initial learning rate for the training. Allowed values: \verb{0 < x <= 1}}

\item{\code{lr_warm_up_ratio}}{\code{double} Number of epochs used for warm up. Allowed values: \verb{0 < x < 0.5}}

\item{\code{optimizer}}{\code{string} determining the optimizer used for training. Allowed values: 'Adam', 'RMSprop', 'AdamW', 'SGD'}

\item{\code{loss_balance_class_weights}}{\code{bool} If \code{TRUE} class weights are generated based on the frequencies of the
training data with the method Inverse Class Frequency. If \code{FALSE} each class has the weight 1.}

\item{\code{loss_balance_sequence_length}}{\code{bool} If \code{TRUE} sample weights are generated for the length of sequences based on
the frequencies of the training data with the method Inverse Class Frequency.
If \code{FALSE} each sequences length has the weight 1.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\itemize{
\item \code{sc_max_k}: All values from sc_min_k up to sc_max_k are successively used. If
the number of \code{sc_max_k} is too high, the value is reduced to a number that allows the calculating of synthetic
units.
\item \verb{pl_anchor:} With the help of this value, the new cases are sorted. For
this aim, the distance from the anchor is calculated and all cases are arranged into an ascending order.
}
}

\subsection{Returns}{
Function does not return a value. It changes the object into a trained classifier.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifiersBasedOnProtoNet-predict_with_samples"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifiersBasedOnProtoNet-predict_with_samples}{}}}
\subsection{Method \code{predict_with_samples()}}{
Method for predicting the class of given data (query) based on provided examples (sample).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifiersBasedOnProtoNet$predict_with_samples(
  newdata,
  batch_size = 32,
  ml_trace = 1,
  embeddings_s = NULL,
  classes_s = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all cases which should be predicted. They form the query set.}

\item{\code{batch_size}}{\code{int} batch size.}

\item{\code{ml_trace}}{\code{int} \code{ml_trace=0} does not print any information about the training process from pytorch on the console. Allowed values: \verb{0 <= x <= 1}}

\item{\code{embeddings_s}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all reference examples. They form the sample set.}

\item{\code{classes_s}}{Named \code{factor} containing the classes for every case within \code{embeddings_s}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a \code{data.frame} containing the predictions and the probabilities of the different labels for each
case.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifiersBasedOnProtoNet-embed"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifiersBasedOnProtoNet-embed}{}}}
\subsection{Method \code{embed()}}{
Method for embedding documents. Please do not confuse this type of embeddings with the embeddings of
texts created by an object of class \link{TextEmbeddingModel}. These embeddings embed documents according to their
similarity to specific classes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifiersBasedOnProtoNet$embed(
  embeddings_q = NULL,
  embeddings_s = NULL,
  classes_s = NULL,
  batch_size = 32,
  ml_trace = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{embeddings_q}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all cases which should be embedded into the classification space.}

\item{\code{embeddings_s}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all reference examples. They form the sample set. If set to \code{NULL} the trained prototypes are used.}

\item{\code{classes_s}}{Named \code{factor} containing the classes for every case within \code{embeddings_s}.
If set to \code{NULL} the trained prototypes are used.}

\item{\code{batch_size}}{\code{int} batch size.}

\item{\code{ml_trace}}{\code{int} \code{ml_trace=0} does not print any information about the training process from pytorch on the console. Allowed values: \verb{0 <= x <= 1}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a \code{list} containing the following elements
\itemize{
\item \code{embeddings_q}: embeddings for the cases (query sample).
\item \code{distances_q}: \code{matrix} containing the distance of every query case to every prototype.
\item \code{embeddings_prototypes}: embeddings of the prototypes which were learned during training. They represents the
center for the different classes.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifiersBasedOnProtoNet-get_metric_scale_factor"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifiersBasedOnProtoNet-get_metric_scale_factor}{}}}
\subsection{Method \code{get_metric_scale_factor()}}{
Method returns the scaling factor of the metric.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifiersBasedOnProtoNet$get_metric_scale_factor()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the scaling factor of the metric as \code{float}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifiersBasedOnProtoNet-plot_embeddings"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifiersBasedOnProtoNet-plot_embeddings}{}}}
\subsection{Method \code{plot_embeddings()}}{
Method for creating a plot to visualize embeddings and their corresponding centers (prototypes).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifiersBasedOnProtoNet$plot_embeddings(
  embeddings_q,
  classes_q = NULL,
  embeddings_s = NULL,
  classes_s = NULL,
  batch_size = 12,
  alpha = 0.5,
  size_points = 3,
  size_points_prototypes = 8,
  inc_unlabeled = TRUE,
  inc_margin = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{embeddings_q}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all cases which should be embedded into the classification space.}

\item{\code{classes_q}}{Named \code{factor} containg the true classes for every case. Please note that the names must match
the names/ids in \code{embeddings_q}.}

\item{\code{embeddings_s}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} containing the text
embeddings for all reference examples. They form the sample set. If set to \code{NULL} the trained prototypes are used.}

\item{\code{classes_s}}{Named \code{factor} containing the classes for every case within \code{embeddings_s}.
If set to \code{NULL} the trained prototypes are used.}

\item{\code{batch_size}}{\code{int} batch size.}

\item{\code{alpha}}{\code{float} Value indicating how transparent the points should be (important
if many points overlap). Does not apply to points representing prototypes.}

\item{\code{size_points}}{\code{int} Size of the points excluding the points for prototypes.}

\item{\code{size_points_prototypes}}{\code{int} Size of points representing prototypes.}

\item{\code{inc_unlabeled}}{\code{bool} If \code{TRUE} plot includes unlabeled cases as data points.}

\item{\code{inc_margin}}{\code{bool} If \code{TRUE} plot includes the margin around every prototype. Adding margin
requires a trained model. If the model is not trained this argument is treated as set to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a plot of class \code{ggplot}visualizing embeddings.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifiersBasedOnProtoNet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifiersBasedOnProtoNet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifiersBasedOnProtoNet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
