% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Diagnostic performance: Plot ROC curve}
\usage{
plotROC(
  x,
  annotate = FALSE,
  col.diagonal = "#00000080",
  lty.diagonal = "solid",
  lwd.diagonal = 1,
  col = "#303030",
  lwd = 2,
  cex = 2,
  ppv = NULL,
  npv = NULL,
  prevalence = NULL,
  col.pvs = "#888888",
  col.ci = "#dd0000",
  lwd.ci = lwd,
  len.ci = 0.1,
  boot.n = 1000,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{x}{Object of class roc.}

\item{annotate}{Annotate plot.}

\item{col.diagonal}{Color of the diagonal.}

\item{lty.diagonal}{Line type of the diagonal.}

\item{lwd.diagonal}{Line width of the diagonal.}

\item{col}{Color.}

\item{lwd}{Line width.}

\item{cex}{Size of the symbols.}

\item{ppv}{Positive predictive value cutoff}

\item{npv}{Negative predictive value cutoff}

\item{prevalence}{Prevalence of the positive outcome}

\item{col.pvs}{Color of the predictive value triangles}

\item{col.ci}{Color of the positive and negative predictive values.}

\item{lwd.ci}{Line width for the positive and negative predictive values.}

\item{len.ci}{Length of the end segment for positive and negative predictive values (see arrows).}

\item{boot.n}{Number of bootstrap replicates for the computation of the confidence interval of the specificity at NPV and of the sensitivity at PPV.}

\item{conf.level}{Width of the confidence interval of the specificity at NPV and of the sensitivity at PPV.}

\item{...}{parameters to be passed to plot.}
}
\value{
A list with the following elements:
\itemize{
\item{\code{AUC}: A numeric vector of length 3 containing the median, lower bound, and upper bound of the AUC.}
\item{\code{PPV}: The positive predictive value cutoff.}
\item{\code{sensitivity@PPV}: A numeric vector of length 3 containing the median, lower bound, and upper bound of the sensitivity at the specified PPV.}
\item{\code{NPV}: The negative predictive value cutoff.}
\item{\code{specificity@NPV}: A numeric vector of length 3 containing the median, lower bound, and upper bound of the specificity at the specified NPV.}
}
}
\description{
Diagnostic performance: Plot ROC curve
}
\examples{
set.seed(0)
count.neg <- count.pos <- 200
sd.neg <- sd.pos <- 1
mean.neg <- .5
mean.pos <- 1
skew.neg <- -8
skew.pos <- 0
x <- c(sn::rsn(count.neg,mean.neg,sd.neg,skew.neg),
       sn::rsn(count.pos,mean.pos,sd.pos,skew.pos))
y <- ordered(c(rep("neg",count.neg),rep("pos",count.pos)),levels=c("neg","pos"))
r1 <- roc(y,x)
plotROC(r1,ppv=0.2,prevalence=0.05,boot.n=1e2)
skew.neg <- 0
skew.pos <- 8
x <- c(sn::rsn(count.neg,mean.neg,sd.neg,skew.neg),
       sn::rsn(count.pos,mean.pos,sd.pos,skew.pos))
y <- ordered(c(rep("neg",count.neg),rep("pos",count.pos)),levels=c("neg","pos"))
r2 <- roc(y,x)
plotROC(r2,npv=0.995,prevalence=0.05,boot.n=1e2)


}
