% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocthreshold.R
\name{rocthreshold}
\alias{rocthreshold}
\title{rocthreshold}
\usage{
rocthreshold(x, y, cut, input, prevalence = NULL, annotate = FALSE)
}
\arguments{
\item{x}{either a ROC object or the predictor to build the ROC curve}

\item{y}{if x is not a ROC object, the binary outcome of the ROC curve}

\item{cut}{cutoff value}

\item{input}{cutoff type, either sensitivity, specificity, threshold, PPV or NPV}

\item{prevalence}{Prevalence of the endpoint in the study population.}

\item{annotate}{if TRUE, the full ROC curve is returned as an attribute}
}
\value{
a vector with sensitivity, specificity, threshold, PPV and NPV at the given cutoff.
}
\description{
Compute ROC sensitivity, specificity and threshold for a given cutoff.
}
\details{
This function computes the sensitivity, specificity, threshold, PPV and NPV 
at a given cutoff value from a ROC curve.

NPV and PPV are computed only if a prevalence is provided as input.

If the ROC curve is not provided, it will be computed from the predictor and outcome.
}
