% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addVolumeFraction.R
\name{addVolumeFraction}
\alias{addVolumeFraction}
\title{Symbolize Volume Fraction within a Soil Profile Collection Plot}
\usage{
addVolumeFraction(
  x,
  colname,
  res = 10,
  cex.min = 0.1,
  cex.max = 0.5,
  pch = 1,
  col = "black"
)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}

\item{colname}{character vector of length 1, naming the column containing volume fraction data (horizon-level attribute). Values should be within 0-100 percent.}

\item{res}{integer, resolution of the grid used to symbolize volume fraction}

\item{cex.min}{minimum symbol size}

\item{cex.max}{maximum symbol size}

\item{pch}{integer, plotting character code}

\item{col}{symbol color, either a single color or as many colors as there are horizons in \code{x}}
}
\description{
Symbolize volume fraction on an existing soil profile collection plot.
}
\details{
This function can only be called after plotting a \code{SoilProfileCollection} object. Details associated with a call to \code{plotSPC()} are automatically accounted for within this function: e.g. \code{plot.order}, \code{width}, etc..
}
\note{
It may be necessary to adjust both \code{res}, \code{cex.min}, and \code{cex.max} for optimal legibility.
}
\seealso{
\code{\link[=plotSPC]{plotSPC()}}
}
\author{
D.E. Beaudette
}
