% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-methods.R
\name{subset,SoilProfileCollection-method}
\alias{subset,SoilProfileCollection-method}
\alias{subset}
\title{Subset a SoilProfileCollection with logical expressions}
\usage{
\S4method{subset}{SoilProfileCollection}(x, ..., greedy = FALSE)
}
\arguments{
\item{x}{A SoilProfileCollection}

\item{...}{Comma-separated set of R expressions that evaluate as TRUE or FALSE. Length for individual expressions matches number of sites OR number of horizons, in \code{object}.}

\item{greedy}{Use "greedy" matching for combination of site and horizon level matches? \code{greedy = TRUE} is the union, whereas \code{greedy = FALSE} (default) is the intersection (of site and horizon matches).}
}
\value{
A SoilProfileCollection.
}
\description{
\code{subset()} is a function used for extracting profiles from a SoilProfileCollection based on logical criteria. It allows the user to specify an arbitrary number of logical vectors (equal in length to site or horizon), separated by commas. The function includes some support for non-standard evaluation.
}
\details{
To minimize likelihood of issues with non-standard evaluation context, especially when using \code{subset()} inside another function, all expressions used in \code{...} should be in terms of variables that are in the site or horizon data frame.
}
\author{
Andrew G. Brown.
}
