% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labellers.R
\name{label_date_jp}
\alias{label_date_jp}
\alias{label_date_jp_gen}
\title{Japanese date labeller for ggplot2}
\usage{
label_date_jp(labels, format = default_format(), tz = NULL)

label_date_jp_gen(format = default_format(), tz = NULL)
}
\arguments{
\item{labels}{A vector of values coercible to Date objects.}

\item{format}{A date-time format string following ICU conventions.}

\item{tz}{A time zone used when coercing values to Date objects.}
}
\value{
\itemize{
\item \code{label_date_jp()} returns a character vector of formatted date labels.
\item \code{label_date_jp_gen()} returns a labeller function for use in ggplot2 scales.
}
}
\description{
Formats date labels using the Japanese calendar system and returns
labels suitable for use with ggplot2 scales.
}
\details{
This labeller formats dates according to a locale-aware Japanese
calendar, allowing era-based representations such as Reiwa or Heisei.
The output is intended for discrete or continuous date scales in ggplot2.
}
\examples{
date_range <- function(start, days) {
  start <- as.POSIXct(start)
  c(start, start + days * 24 * 60 * 60)
}
two_months <- date_range("2025-12-31", 60)

label_date_jp(two_months)
if (requireNamespace("scales", quietly = TRUE)) {
  scales::demo_datetime(two_months, labels = label_date_jp_gen())
}
}
