% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-sampling.R
\name{auk_sampling}
\alias{auk_sampling}
\title{Reference to eBird sampling event file}
\usage{
auk_sampling(file, sep = "\\t")
}
\arguments{
\item{file}{character; input sampling event data file, which contains
checklist data from eBird.}

\item{sep}{character; the input field separator, the eBird data are tab
separated so this should generally not be modified. Must only be a single
character and space delimited is not allowed since spaces appear in many of
the fields.}
}
\value{
An \code{auk_sampling} object storing the file reference and the desired
filters once created with other package functions.
}
\description{
Create a reference to an eBird sampling event file in preparation for
filtering using AWK. For working with the sightings data use \code{auk_ebd()},
only use \code{auk_sampling()} if you intend to only work with checklist-level
data.
}
\details{
eBird data can be downloaded as a tab-separated text file from the
\href{http://ebird.org/ebird/data/download}{eBird website} after submitting a
request for access. In the eBird Basic Dataset (EBD) each row corresponds
to a observation of a single bird species on a single checklist, while the
sampling event data file contains a single row for every checklist. This
function creates an R object to reference only the sampling data.
}
\examples{
# get the path to the example data included in the package
# in practice, provide path to the sampling event data
# e.g. f <- "data/ebd_sampling_relFeb-2018.txt"
f <- system.file("extdata/zerofill-ex_sampling.txt", package = "auk")
auk_sampling(f)
}
\seealso{
Other objects: 
\code{\link{auk_ebd}()}
}
\concept{objects}
