% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.r
\name{reduce.database}
\alias{reduce.database}
\title{Remove database relations not linked to the main relations}
\usage{
\method{reduce}{database}(x, main, ...)
}
\arguments{
\item{x}{A database, whose relations are to be filtered.}

\item{main}{A character vector, containing names of relations to be
considered as the "main" relations. If missing, taken to be the names of
all relations with the largest record count.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A database, with the auxiliary relations and foreign key
references removed.
}
\description{
Filters a database's relations, keeping only the main relations, and those
considered ancestors via foreign key references. Foreign
key references involving removed relations are also removed.
}
\details{
The main relations are considered to be the relations with the largest number
of records.

Using \code{\link{rejoin}} on the database resulting from \code{reduce} is
likely to fail or return incomplete results.
}
