% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{default_azure_url}
\alias{default_azure_url}
\title{Get default Azure OAuth URLs}
\usage{
default_azure_url(
  endpoint = NULL,
  oauth_host = default_azure_host(),
  tenant_id = default_azure_tenant_id()
)
}
\arguments{
\item{endpoint}{A character string specifying which endpoint URL to return.
Must be one of: \code{"authorize"}, \code{"token"}, or \code{"devicecode"}. If \code{NULL}
(default), returns a list of all endpoint URLs.}

\item{oauth_host}{A character string specifying the Azure authority host.
Defaults to \code{\link[=default_azure_host]{default_azure_host()}}.}

\item{tenant_id}{A character string specifying the tenant ID. Defaults to
\code{\link[=default_azure_tenant_id]{default_azure_tenant_id()}}.}
}
\value{
If \code{endpoint} is specified, returns a character string with the URL.
If \code{endpoint} is \code{NULL}, returns a named list of all endpoint URLs.
}
\description{
Constructs Azure OAuth 2.0 endpoint URLs for a given tenant and authority host.
}
\examples{
# Get all URLs
default_azure_url()

# Get specific endpoint
default_azure_url("token")

# Custom tenant
default_azure_url("authorize", tenant_id = "my-tenant-id")
}
