% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestHillModel.R
\name{findBestHillModel}
\alias{findBestHillModel}
\title{Selects a best-fitting Hill model given defaults}
\usage{
findBestHillModel(
  formula,
  data,
  defaults,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  useBIC = TRUE
)
}
\arguments{
\item{formula}{Either an object of class \code{formula} such as would be provided
to a modeling function like \code{\link[=lm]{lm()}}, or a numeric vector of concentration
values (including 0 or Inf)}

\item{data}{If \code{forumula} is a symbolic formula, a data frame containing the
specified values. If \code{formula} is a numeric vector of concentrations, a
numeric vector of response values}

\item{defaults}{A two value numeric vector containing the default minimal
effect and the default maximal effect, in that order}

\item{weights}{A vector of weights (between 0 and 1) the same length as
\code{conc} and \code{act} which determines the weight with which each measurement
will impact the the sum of squared errors.  Weights will be multiplied by
errors \emph{before} squaring.  If \code{NULL} (the default) all weights will be set
to 1. Can be a numeric vector, or the name of a column in \code{data} if \code{formula}
is a symbolic formula}

\item{start}{A vector of four starting values for the Hill model to be fit.
Any values not being fit will be fixed at these starting values.  If left as
\code{NULL}, a starting vector will be estimated from the data.}

\item{direction}{Determines the possible directionality of the dose response
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effect is \emph{greater} than the minimal effect.  If less than 0, the fitting
wll require tha the maximal effect is \emph{less} than the minimal effect.}

\item{lower}{A length-four vector of lower bounds on the Hill parameter
values.  Any parameters for which you do not wish to specify a bound can be
set to \code{NA}.}

\item{upper}{A vector of upper bounds on the Hill parameter values.  Works
the same as parameter \code{lower}.}

\item{useBIC}{Determines the information criterion to be used.  If \code{TRUE}
(the default), uses the Bayesian information criterion.  If \code{FALSE}, uses
the Akaike information criterion}
}
\value{
An object of class \code{hillrm}.  Contains all of the values found in
any \code{hillrm} object (see \code{\link[=fitHillModel]{fitHillModel()}}), as well as \code{allfits}, a named
list of lists containing the \code{coefficients} and \code{par}vectors for each of the
individual fits, as well as the Bayesian information criterion (\code{bic}) and
Akaike informtion criterion (\code{aic}) values for each fit.
}
\description{
Using the function \code{\link[=fitHillModel]{fitHillModel()}}, this function fits four Hill models
with minimal and maximal effects either varying or fixed at the given
default values; it then selects the best fitting model based on the Bayesian
information criterio or Akaike information criterion, and returns a Hill fit
object with information from all fits included.
}
\examples{
conc <- c(0,2^(-6:3),Inf)
hpar <- c(1,3,0,75)
response <- evalHillModel(conc, hpar) + rnorm(length(conc),sd=7.5)

hfit <- findBestHillModel(conc,response,defaults=c(0,100))
}
