% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_details.R
\name{get_details.jsdglobal}
\alias{get_details.jsdglobal}
\title{Get Details of a Basket Trial Simulation with the Power Prior Design
Based on Global JSD Weights}
\usage{
\method{get_details}{jsdglobal}(
  design,
  n,
  p1 = NULL,
  lambda,
  level = 0.95,
  eps_pair,
  tau = 0,
  eps_all,
  logbase = 2,
  iter = 1000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object of class \code{jsdgen}.}

\item{n}{The sample size per basket.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{eps_pair}{Tuning parameter that determines the amount of borrowing
based on pairwise similarity.}

\item{tau}{Tuning parameter that determines how similar the baskets
have to be that information is shared.}

\item{eps_all}{Tuning parameter that determines the amount of borrowing
based on overall heterogeneity.}

\item{logbase}{Tuning parameter. The base of the logarithm that is used to
calculate the Jensen-Shannon divergence.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A list containing the rejection probabilites, posterior means,
mean squared errors and mean limits of HDI intervals for all baskets as well
as the family-wise error rate.
}
\description{
Get Details of a Basket Trial Simulation with the Power Prior Design
Based on Global JSD Weights
}
\examples{
design <- setup_jsdglobal(k = 3, p0 = 0.2)
get_details(design = design, n = 20, p1 = c(0.2, 0.5, 0.5), lambda = 0.95,
  eps_pair = 2, eps_all = 2, iter = 100)
}
