% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_smooth.R
\name{gaussian_smooth}
\alias{gaussian_smooth}
\title{Smooth probability images with Gaussian filter}
\usage{
gaussian_smooth(x, window_size = 5, sigma = 1)
}
\arguments{
\item{x}{SpatRaster object with probabilities images}

\item{window_size}{Size of the neighborhood.}

\item{sigma}{Standard deviation of the spatial Gaussian kernel}
}
\value{
A SpatRaster object
}
\description{
Takes a classified image with probabilities, and reduces outliers
and smoothens probability according to a Gaussian filter
}
\examples{
if (bayes_run_examples()) {
    # select a file with probability values
    data_dir <- system.file("/extdata/probs/", package = "bayesEO")
    file <- list.files(data_dir)
    # create a full path for the file
    probs_file <- paste0(data_dir, "/", file)
    # provide the labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")
    # read the probs file
    probs <- bayes_read(probs_file, labels)
    # smooth the probability image
    gauss <- gaussian_smooth(probs,
            window_size = 5,
            sigma = 1
    )
    # plot the probability image
    bayes_plot_probs(gauss)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
