% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression_Functions.R
\name{distreg.sas}
\alias{distreg.sas}
\title{Semi-asymptotic bayesian distribution}
\usage{
distreg.sas(ind, drabj, data, vcovfn = "vcov", iter = 100)
}
\arguments{
\item{ind}{index of object in list \code{drabj} (i.e. a threshold value) from which to take draws}

\item{drabj}{object from dr_asympar()}

\item{data}{dataframe, first column is the outcome}

\item{vcovfn}{a string denoting the function to extract the variance-covariance. Defaults at
"vcov". Other variance-covariance estimators in the sandwich package are usable.}

\item{iter}{number of draws to simulate}
}
\value{
fitob vector of random draws from density of F(yo) using semi-asymptotic BDR
}
\description{
\code{distreg.sas} takes input object from dr_asympar() for semi asymptotic bayesian 
distribution. This involves taking random draws from the normal approximation of the 
posterior at each threshold value.
}
\examples{
y = faithful$waiting
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
qtaus = quantile(y,c(0.05,0.25,0.5,0.75,0.95))
drabj<- dr_asympar(y=y,x=x,thresh = qtaus); data = data.frame(y,x)
drsas1 = lapply(1:5,distreg.sas,drabj=drabj,data=data,iter=100)
drsas2 = lapply(1:5,distreg.sas,drabj=drabj,data=data,vcovfn="vcovHC",iter=100)
par(mfrow=c(3,2));invisible(lapply(1:5,function(i)plot(density(drsas1[[i]],.1))));par(mfrow=c(1,1))
par(mfrow=c(3,2));invisible(lapply(1:5,function(i)plot(density(drsas2[[i]],.1))));par(mfrow=c(1,1))

}
