% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-table.R
\name{kit_summary_table}
\alias{kit_summary_table}
\title{Summarize model fit}
\usage{
kit_summary_table(
  fit,
  ...,
  data = NULL,
  accuracy = 0.01,
  cri_range = 0.95,
  ndraws = NULL
)
}
\arguments{
\item{fit}{\link[rstan:stanfit-class]{rstan::stanfit} object}

\item{...}{variables to group by in estimate}

\item{data}{data used for model fitting. Can also include \code{p_use} column
which can be used to plot true values if derived from simulated data.}

\item{accuracy}{A number to round to. Use (e.g.) 0.01 to show 2 decimal
places of precision. If NULL, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.}

\item{cri_range}{The range of the credible interval e.g. 0.95}

\item{ndraws}{Number of draws to use in estimate}
}
\value{
A \link[tibble:tibble]{tibble::tibble}
\itemize{
\item{Probability of kit use if distributed}
\item{Estimated as distributed}
\item{Proportion kits distributed that are reported}
\item{Estimated kits used}
\item{Proportion kits used that are reported}
\item{Proportion kits ordered that are used}
}
}
\description{
Provides a summary of:
\itemize{
\item Estimated kits distributed
\item Percentage of kits distributed that are reported
\item Estimated kits used
\item percentage of kits used that are reported
\item percentage of kits orders that are used
\item probability kit used if distributed
}
}
\examples{
\dontrun{
  fit <- est_naloxone(d)
  kit_summary_table(fit,regions,data = d)
}
}
\seealso{
Other plots: 
\code{\link{plot_kit_use}()}
}
\concept{plots}
