% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDataBiometrics.r
\docType{data}
\name{popvol}
\alias{popvol}
\title{Population of stand-volume for 400 elements.}
\format{
Contains two variables, as follows:
\describe{
  \item{id}{Plot number, or ID.}
\item{vol}{Stand volume, in m\eqn{^{3}}{^3}/ha}
 }
}
\source{
Population data of forest volume. Each row represents a plot, and
their respective measured standing trees volume. Data from Zhorer (1980).
}
\usage{
data(popvol)
}
\description{
A list of elements containing stand-volume (in m\eqn{^{3}}{^3}/ha) values measured
in sample plots. Thus, the population size is 400, and the random variable is
forest volume.  The values were digitized from the book of Zohrer (1980).
}
\examples{
data(popvol)    
sum(popvol$vol) 
mean(popvol$vol) 
hist(popvol$vol)
}
\references{
- Zohrer F. 1980. Forstinventur. Ein Leitfaden fur Studium und Praxis.
 Pareys Studientexte Nr. 26. Parey. Berlin, Germany. 207
}
\keyword{datasets}
