% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_3.R
\name{getters.out}
\alias{getters.out}
\alias{get_species_data}
\alias{get_eval_data}
\alias{get_options}
\alias{get_calib_lines}
\alias{get_formal_data}
\alias{get_projected_models}
\alias{free}
\alias{get_predictions}
\alias{get_kept_models}
\alias{get_built_models}
\alias{get_evaluations}
\alias{get_variables_importance}
\alias{get_species_data,BIOMOD.formated.data-method}
\alias{get_species_data,BIOMOD.formated.data.PA-method}
\alias{get_eval_data,BIOMOD.formated.data-method}
\alias{get_options,BIOMOD.models.out-method}
\alias{get_calib_lines,BIOMOD.models.out-method}
\alias{get_formal_data,BIOMOD.models.out-method}
\alias{get_predictions,BIOMOD.models.out-method}
\alias{get_built_models,BIOMOD.models.out-method}
\alias{get_evaluations,BIOMOD.models.out-method}
\alias{get_variables_importance,BIOMOD.models.out-method}
\alias{get_projected_models,BIOMOD.projection.out-method}
\alias{free,BIOMOD.projection.out-method}
\alias{get_predictions,BIOMOD.projection.out-method}
\alias{get_formal_data,BIOMOD.ensemble.models.out-method}
\alias{get_built_models,BIOMOD.ensemble.models.out-method}
\alias{get_kept_models,BIOMOD.ensemble.models.out-method}
\alias{get_predictions,BIOMOD.ensemble.models.out-method}
\alias{get_evaluations,BIOMOD.ensemble.models.out-method}
\alias{get_variables_importance,BIOMOD.ensemble.models.out-method}
\title{Functions to extract informations from \code{\link{BIOMOD.models.out}}, 
\code{\link{BIOMOD.projection.out}} or \code{\link{BIOMOD.ensemble.models.out}} objects}
\usage{
\S4method{get_species_data}{BIOMOD.formated.data}(obj)

\S4method{get_species_data}{BIOMOD.formated.data.PA}(obj)

\S4method{get_eval_data}{BIOMOD.formated.data}(obj)

\S4method{get_options}{BIOMOD.models.out}(obj)

\S4method{get_calib_lines}{BIOMOD.models.out}(obj, as.data.frame = FALSE, PA = NULL, run = NULL)

\S4method{get_formal_data}{BIOMOD.models.out}(obj, subinfo = NULL)

\S4method{get_predictions}{BIOMOD.models.out}(
  obj,
  evaluation = FALSE,
  full.name = NULL,
  PA = NULL,
  run = NULL,
  algo = NULL,
  model.as.col = FALSE
)

\S4method{get_built_models}{BIOMOD.models.out}(obj, full.name = NULL, PA = NULL, run = NULL, algo = NULL)

\S4method{get_evaluations}{BIOMOD.models.out}(
  obj,
  full.name = NULL,
  PA = NULL,
  run = NULL,
  algo = NULL,
  metric.eval = NULL
)

\S4method{get_variables_importance}{BIOMOD.models.out}(
  obj,
  full.name = NULL,
  PA = NULL,
  run = NULL,
  algo = NULL,
  expl.var = NULL
)

\S4method{get_projected_models}{BIOMOD.projection.out}(
  obj,
  full.name = NULL,
  PA = NULL,
  run = NULL,
  algo = NULL,
  merged.by.algo = NULL,
  merged.by.run = NULL,
  merged.by.PA = NULL,
  filtered.by = NULL
)

\S4method{free}{BIOMOD.projection.out}(obj)

\S4method{get_predictions}{BIOMOD.projection.out}(
  obj,
  metric.binary = NULL,
  metric.filter = NULL,
  full.name = NULL,
  PA = NULL,
  run = NULL,
  algo = NULL,
  merged.by.algo = NULL,
  merged.by.run = NULL,
  merged.by.PA = NULL,
  filtered.by = NULL,
  model.as.col = FALSE,
  ...
)

\S4method{get_formal_data}{BIOMOD.ensemble.models.out}(obj, subinfo = NULL)

\S4method{get_built_models}{BIOMOD.ensemble.models.out}(
  obj,
  full.name = NULL,
  merged.by.algo = NULL,
  merged.by.run = NULL,
  merged.by.PA = NULL,
  filtered.by = NULL,
  algo = NULL
)

\S4method{get_kept_models}{BIOMOD.ensemble.models.out}(obj)

\S4method{get_predictions}{BIOMOD.ensemble.models.out}(
  obj,
  evaluation = FALSE,
  full.name = NULL,
  merged.by.algo = NULL,
  merged.by.run = NULL,
  merged.by.PA = NULL,
  filtered.by = NULL,
  algo = NULL,
  model.as.col = FALSE
)

\S4method{get_evaluations}{BIOMOD.ensemble.models.out}(
  obj,
  full.name = NULL,
  merged.by.algo = NULL,
  merged.by.run = NULL,
  merged.by.PA = NULL,
  filtered.by = NULL,
  algo = NULL,
  metric.eval = NULL
)

\S4method{get_variables_importance}{BIOMOD.ensemble.models.out}(
  obj,
  full.name = NULL,
  merged.by.algo = NULL,
  merged.by.run = NULL,
  merged.by.PA = NULL,
  filtered.by = NULL,
  algo = NULL,
  expl.var = NULL
)
}
\arguments{
\item{obj}{a \code{\link{BIOMOD.formated.data}}, \code{\link{BIOMOD.formated.data.PA}}, 
\code{\link{BIOMOD.models.out}}, \code{\link{BIOMOD.projection.out}} or 
\code{\link{BIOMOD.ensemble.models.out}} object}

\item{as.data.frame}{a \code{logical} defining whether output should be returned as 
\code{data.frame} or \code{array} object}

\item{PA}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing pseudo-absence set to be loaded, must be among \code{PA1}, 
\code{PA2}, \code{...}, \code{allData}}

\item{run}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing repetition set to be loaded, must be among \code{RUN1}, 
\code{RUN2}, \code{...}, \code{allRun}}

\item{subinfo}{a \code{character} corresponding to the information to be extracted, must be 
among \code{NULL}, \code{expl.var.names}, \code{resp.var}, \code{expl.var}, \code{MinMax}, 
\code{eval.resp.var}, \code{eval.expl.var} (see Details)}

\item{evaluation}{a \code{logical} defining whether evaluation data should be used or not}

\item{full.name}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing model names to be kept, must be either \code{all} or a 
sub-selection of model names that can be obtained with the \code{\link{get_built_models}} 
function}

\item{algo}{(\emph{optional, default} \code{NULL}) \cr 
A \code{character} containing algorithm to be loaded, must be either 
\code{ANN}, \code{CTA}, \code{DNN}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{SRE}, \code{XGBOOST}}

\item{model.as.col}{(\emph{optional, default} \code{FALSE}) \cr
A \code{boolean} given to \code{\link{get_predictions}}. If \code{TRUE} 
prediction are returned as a wide \code{data.frame} with each column containing
predictions for a single model and corresponding to the old output given by
\pkg{biomod2} in version < 4.2-2. If \code{FALSE} predictions are returned 
as a long \code{data.frame} with many additional informations readily 
available.}

\item{metric.eval}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing evaluation metric to be kept, must be among \code{POD}, 
\code{FAR}, \code{POFD}, \code{SR}, \code{ACCURACY}, \code{BIAS}, \code{AUCroc}, \code{AUCprg}, \code{TSS}, 
\code{KAPPA}, \code{OR}, \code{ORSS}, \code{CSI}, \code{ETS}, \code{BOYCE}, \code{MPA}}

\item{expl.var}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing explanatory variables to be kept, that can be obtained with the 
\code{\link{get_formal_data}(obj, subinfo = 'expl.var.names')} function}

\item{merged.by.algo}{(\emph{optional, default} \code{NULL}) \cr 
A \code{character} containing merged algorithm to be loaded, must be among 
\code{ANN}, \code{CTA}, \code{DNN}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{SRE}, \code{XGBOOST}, \code{mergedAlgo}}

\item{merged.by.run}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing merged repetition set to be loaded, must be among \code{RUN1}, 
\code{RUN2}, \code{...}, \code{mergedRun}}

\item{merged.by.PA}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing merged pseudo-absence set to be loaded, must be among \code{PA1}, 
\code{PA2}, \code{...}, \code{mergedData}}

\item{filtered.by}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing evaluation metric selected to filter single models to build the 
ensemble models, must be among \code{POD}, \code{FAR}, \code{POFD}, \code{SR}, 
\code{ACCURACY}, \code{BIAS}, \code{AUCroc}, \code{AUCprg}, \code{TSS}, \code{KAPPA}, \code{OR}, \code{ORSS}, 
\code{CSI}, \code{ETS}, \code{BOYCE}, \code{MPA}}

\item{metric.binary}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing evaluation metric selected to transform predictions into binary 
values, must be among \code{POD}, \code{FAR}, \code{POFD}, \code{SR}, \code{ACCURACY}, 
\code{BIAS}, \code{AUCroc}, \code{AUCprg}, \code{TSS}, \code{KAPPA}, \code{OR}, \code{ORSS}, \code{CSI}, 
\code{ETS}, \code{BOYCE}, \code{MPA}}

\item{metric.filter}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing evaluation metric to filter predictions, must be among \code{POD}, 
\code{FAR}, \code{POFD}, \code{SR}, \code{ACCURACY}, \code{BIAS}, \code{AUCroc}, \code{AUCprg}, \code{TSS}, 
\code{KAPPA}, \code{OR}, \code{ORSS}, \code{CSI}, \code{ETS}, \code{BOYCE}, \code{MPA}}

\item{\ldots}{(\emph{optional, one or several of the following arguments depending on the selected 
function})}
}
\value{
\describe{
  \item{\code{get_species_data}}{a \code{data.frame} combining \code{data.species}, 
  \code{coord}, \code{data.env.var} (and \code{PA.table}) slots of 
  \code{\link{BIOMOD.formated.data}} (or \code{\link{BIOMOD.formated.data.PA}}) object}
  \item{\code{get_eval_data}}{a \code{data.frame} combining \code{eval.data.species}, 
  \code{eval.coord}, \code{eval.data.env.var} slots of 
  \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}} object}

  \item{\code{get_options}}{a
  \code{\link{BIOMOD.stored.options-class}} object from the
  \code{models.options} slot of a \code{\link{BIOMOD.models.out-class}}
  object} \item{\code{get_calib_lines}}{a
  \code{\link{BIOMOD.stored.data.frame-class}} object from the \code{calib.lines}
  slot of a \code{\link{BIOMOD.models.out}} object}

  \item{\code{get_projected_models}}{a \code{vector} from the
  \code{models.projected} slot of a \code{\link{BIOMOD.projection.out}}
  object}

  \item{\code{get_predictions}}{a \code{\link{BIOMOD.stored.data}} object
  from the \code{proj.out} slot of a \code{\link{BIOMOD.models.out}},
  \code{\link{BIOMOD.projection.out}} or
  \code{\link{BIOMOD.ensemble.models.out}} object}

  \item{\code{get_kept_models}}{a \code{vector} containing names of the kept
  models of a \code{\link{BIOMOD.ensemble.models.out}} object}

  \item{\code{get_formal_data}}{depending on the \code{subinfo} parameter :
  \describe{
    \item{\code{NULL}}{a \code{\link{BIOMOD.stored.formated.data-class}} (or
    \code{\link{BIOMOD.stored.models.out-class}}) object from the
    \code{formated.input.data} (or \code{models.out}) slot of a
    \code{\link{BIOMOD.models.out}} (or
    \code{\link{BIOMOD.ensemble.models.out}}) object}
    
    \item{\code{expl.var.names}}{a \code{vector} from the
    \code{expl.var.names} slot of a \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    \item{\code{resp.var}}{a \code{vector} from the \code{data.species} slot
    of the \code{formated.input.data} slot of a
    \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{expl.var}}{a \code{data.frame} from the \code{data.env.var}
    slot of the \code{formated.input.data} slot of a
    \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{MinMax}}{a \code{list} of minimum and maximum values (or
    levels if factorial) of variable contained in the \code{data.env.var}
    slot of the \code{formated.input.data} slot of a
    \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{eval.resp.var}}{a \code{vector} from the
    \code{eval.data.species} slot of the \code{formated.input.data} slot of
    a \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
    
    \item{\code{eval.expl.var}}{a \code{data.frame} from the
    \code{eval.data.env.var} slot of the \code{formated.input.data} slot of
    a \code{\link{BIOMOD.models.out}} or
    \code{\link{BIOMOD.ensemble.models.out}} object}
  }
  }
  \item{\code{get_built_models}}{a \code{vector} from the
  \code{models.computed} slot (or \code{em.computed}) of a
  \code{\link{BIOMOD.models.out}} (or
  \code{\link{BIOMOD.ensemble.models.out}}) object}
  \item{\code{get_evaluations}}{a data.frame from the \code{models.evaluation}
   slot (or \code{model_evaluation} of each model in \code{em.computed}) of a
  \code{\link{BIOMOD.models.out}} (or \code{\link{BIOMOD.ensemble.models.out}})
   object. Contains evaluation metric for different models and dataset. 
   Evaluation metric are calculated on the calibrating data (column \code{calibration}),
   on the cross-validation data (column \code{validation}) or on the evaluation data 
   (column \code{evaluation}). \cr \emph{For cross-validation data, see \code{CV.[...]} 
   parameters in \code{\link{BIOMOD_Modeling}} function ; for evaluation data, see 
   \code{eval.[...]} parameters in \code{\link{BIOMOD_FormatingData}}.}}
  \item{\code{get_variables_importance}}{a
  \code{\link{BIOMOD.stored.data.frame-class}} from
  the \code{variables.importance} slot (or \code{model_variables_importance}
  of each model in \code{em.models}) of a \code{\link{BIOMOD.models.out}}
  (or \code{\link{BIOMOD.ensemble.models.out}}) object}
}
}
\description{
These functions allow the user to easily retrieve informations stored in the 
different \pkg{biomod2} objects from the different modeling steps, such as modeling options 
and formated data, models used or not, predictions, evaluations, variables importance.
}
\seealso{
\code{\link{BIOMOD.models.out}}, \code{\link{BIOMOD.projection.out}}, 
\code{\link{BIOMOD.ensemble.models.out}}

Other Toolbox functions: 
\code{\link{getters.bm}},
\code{\link{load_stored_object}()},
\code{\link{predict.bm}},
\code{\link{predict.em}},
\code{\link{predict2.bm}},
\code{\link{predict2.em}},
\code{\link{setters}}
}
\author{
Damien Georges
}
\concept{Toolbox functions}
