% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_measures.R
\name{effect_measures}
\alias{effect_measures}
\alias{print.effect_measures}
\title{Effect Measures}
\usage{
effect_measures(
  exposed_event,
  exposed_no_event,
  unexposed_event,
  unexposed_no_event,
  alpha = 0.05,
  correction = TRUE
)

\method{print}{effect_measures}(x, ...)
}
\arguments{
\item{exposed_event}{Numeric value indicating the number of events in the exposed group.}

\item{exposed_no_event}{Numeric value indicating the number of non-events in the exposed group.}

\item{unexposed_event}{Numeric value indicating the number of events in the unexposed group.}

\item{unexposed_no_event}{Numeric value indicating the number of non-events in the unexposed group.}

\item{alpha}{Numeric value between 0 and 1 specifying the alpha level for
confidence intervals (CI). Default: 0.05.}

\item{correction}{Logical parameter that indicates whether a continuity correction (0.5) will be applied
when any cell contains 0. Default: TRUE.}

\item{x}{An object of class "effect_measures".}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class "effect_measures" containing the contingency table,
effect size estimates (OR, RR, risk difference, NNT/NNH), and related statistics.
}
\description{
Calculates measures of effect: Odds Ratio (OR), Risk Ratio (RR), and either
Number Needed to Treat (NNT) or Number Needed to Harm (NNH).
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(effect_measures)}: Print method for objects of class "effect_measures".

}}
\examples{
effect_measures(exposed_event = 15, 
                exposed_no_event = 85,
                unexposed_event = 5,
                unexposed_no_event = 95)

}
