% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-model.R
\name{use_model_template}
\alias{use_model_template}
\title{Create a file with a template for adding a new model (for developers)}
\usage{
use_model_template(
  model_name,
  custom_family = FALSE,
  stanvar_blocks = c("data", "tdata", "parameters", "tparameters", "model", "likelihood",
    "genquant", "functions"),
  open_files = TRUE,
  testing = FALSE
)
}
\arguments{
\item{model_name}{A string with the name of the model. The file will be named
\code{model_model_name.R} and all necessary functions will be created with
the appropriate names and structure. The file will be saved in the \verb{R/}
directory}

\item{custom_family}{Logical; Do you plan to define a brms::custom_family()?
If TRUE the function will add a section for the custom family, placeholders
for the stan_vars and corresponding empty .stan files in
\verb{inst/stan_chunks/}, that you can fill For an example, see the sdm
model in \verb{/R/model_sdm.R}. If FALSE (default) the function will
not add the custom family section nor stan files.}

\item{stanvar_blocks}{A character vector with the names of the blocks that
will be added to the custom family section. See \code{\link[brms:stanvar]{brms::stanvar()}} for more
details. The default lists all the possible blocks, but it is unlikely that
you will need all of them. You can specify a vector of only those that you
need. The function will add a section for each block in the list}

\item{open_files}{Logical; If TRUE (default), the function will open the
template files that were created in RStudio}

\item{testing}{Logical; If TRUE, the function will return the file content but
will not save the file. If FALSE (default), the function will save the file}
}
\value{
If \code{testing} is TRUE, the function will return the file content as a
string. If \code{testing} is FALSE, the function will return NULL
}
\description{
Create a file with a template for adding a new model (for developers)
}
\details{
If you get a warning during check() about non-ASCII characters, this
is often due to the citation field. You can find what the problem is by
running

\if{html}{\out{<div class="sourceCode r">}}\preformatted{remotes::install_github("eddelbuettel/dang")
dang::checkPackageAsciiCode(dir = ".")
}\if{html}{\out{</div>}}

usually rewriting the numbers (issue, page numbers) manually fixes it
}
\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(usethis)

# create a new model file without a brms::custom_family, and open the file
use_model_template("newmodel")

# create a new model file with a brms::custom_family, three .stan files in
# inst/stan_chunks/ and open the files
use_model_template("abc",
  custom_family = TRUE,
  stanvar_blocks = c("functions", "likelihood", "tdata")
)
\dontshow{\}) # examplesIf}
}
\keyword{developer}
\keyword{internal}
