% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skew_normal_distribution.R
\name{skew_normal_distribution}
\alias{skew_normal_distribution}
\alias{skew_normal_pdf}
\alias{skew_normal_lpdf}
\alias{skew_normal_cdf}
\alias{skew_normal_lcdf}
\alias{skew_normal_quantile}
\title{Skew Normal Distribution Functions}
\usage{
skew_normal_pdf(x, location = 0, scale = 1, shape = 0)

skew_normal_lpdf(x, location = 0, scale = 1, shape = 0)

skew_normal_cdf(x, location = 0, scale = 1, shape = 0)

skew_normal_lcdf(x, location = 0, scale = 1, shape = 0)

skew_normal_quantile(p, location = 0, scale = 1, shape = 0)
}
\arguments{
\item{x}{quantile}

\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{shape}{shape parameter (default is 0)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Skew Normal distribution.
}
\examples{
# Skew Normal distribution with location = 0, scale = 1, shape = 0
skew_normal_pdf(0)
skew_normal_lpdf(0)
skew_normal_cdf(0)
skew_normal_lcdf(0)
skew_normal_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/skew_normal_dist.html}{Boost Documentation} for more details on the mathematical background.
}
