% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{cardinal_quadratic_b_spline}
\alias{cardinal_quadratic_b_spline}
\title{Cardinal Quadratic B-Spline Interpolator}
\usage{
cardinal_quadratic_b_spline(
  y,
  t0,
  h,
  left_endpoint_derivative = NULL,
  right_endpoint_derivative = NULL
)
}
\arguments{
\item{y}{Numeric vector of data points to interpolate.}

\item{t0}{Numeric scalar representing the starting point of the data.}

\item{h}{Numeric scalar representing the spacing between data points.}

\item{left_endpoint_derivative}{Optional numeric scalar for the derivative at the left endpoint.}

\item{right_endpoint_derivative}{Optional numeric scalar for the derivative at the right endpoint.}
}
\value{
An object of class \code{cardinal_quadratic_b_spline} with methods:
\itemize{
\item \code{spline(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
}
}
\description{
Constructs a cardinal quadratic B-spline interpolator given control points.
}
\examples{
y <- c(0, 1, 0, 1)
t0 <- 0
h <- 1
interpolator <- cardinal_quadratic_b_spline(y, t0, h)
xi <- 0.5
interpolator$spline(xi)
interpolator$prime(xi)
}
