% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-polar.R
\name{br_show_risk_network}
\alias{br_show_risk_network}
\title{Show connected risk network plot}
\usage{
br_show_risk_network(breg, ...)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{...}{Arguments passing to \code{\link[=br_get_results]{br_get_results()}} for subsetting data table.}
}
\value{
A plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
lung <- survival::lung
# Cox-PH regression
mod_surv <- br_pipeline(
  data = lung,
  y = c("time", "status"),
  x = c("age", "ph.ecog", "ph.karno"),
  x2 = c("factor(sex)"),
  method = "coxph"
)
p <- br_show_risk_network(mod_surv)
p
}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}

Other risk_network: 
\code{\link{polar_connect}()},
\code{\link{polar_init}()}
}
\concept{br_show}
\concept{risk_network}
