% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_forest_ggstats}
\alias{br_show_forest_ggstats}
\title{Show a forest plot with \code{ggstats} interface}
\usage{
br_show_forest_ggstats(breg, idx = NULL, ...)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{idx}{Index or names (focal variables) of the model(s).}

\item{...}{Arguments passing to \code{\link[ggstats:ggcoef_model]{ggstats::ggcoef_table()}} or \code{\link[ggstats:ggcoef_model]{ggstats::ggcoef_compare()}} excepts \code{model}.}
}
\value{
A plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Provides an interface to visualize the model results with \href{https://github.com/larmarange/ggstats/}{\strong{ggstats}} package.
}
\examples{
if (rlang::is_installed("ggstats")) {
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )
  br_show_forest_ggstats(m)
}

}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
