% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repos.R
\name{db_repo_get_all}
\alias{db_repo_get_all}
\title{Get All Repos}
\usage{
db_repo_get_all(
  path_prefix,
  next_page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path_prefix}{Filters repos that have paths starting with the given path
prefix.}

\item{next_page_token}{Token used to get the next page of results. If not
specified, returns the first page of results as well as a next page token if
there are more results.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Get All Repos
}
\details{
Returns repos that the calling user has Manage permissions on.
Results are paginated with each page containing twenty repos.
}
\seealso{
Other Repos API: 
\code{\link{db_repo_create}()},
\code{\link{db_repo_delete}()},
\code{\link{db_repo_get}()},
\code{\link{db_repo_update}()}
}
\concept{Repos API}
