% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-data-frame.R
\name{btw_tool_env_describe_data_frame}
\alias{btw_tool_env_describe_data_frame}
\title{Tool: Describe data frame}
\usage{
btw_tool_env_describe_data_frame(
  data_frame,
  format = c("skim", "glimpse", "print", "json"),
  max_rows = 5,
  max_cols = 100,
  package = NULL,
  `_intent` = ""
)
}
\arguments{
\item{data_frame}{The data frame to describe}

\item{format}{One of \code{"skim"}, \code{"glimpse"}, \code{"print"}, or \code{"json"}.
\itemize{
\item \code{"skim"} is the most information-dense format for describing the data. It
uses and returns the same information as \code{\link[skimr:skim]{skimr::skim()}} but formatting as
a JSON object that describes the dataset.
\item To glimpse the data column-by-column, use \code{"glimpse"}. This is
particularly helpful for getting a sense of data frame column names,
types, and distributions, when pairings of entries in individual rows
aren't particularly important.
\item To just print out the data frame, use \code{print()}.
\item To get a json representation of the data, use \code{"json"}. This is
particularly helpful when the pairings among entries in specific rows
are important to demonstrate.
}}

\item{max_rows}{The maximum number of rows to show in the data frame. Only
applies when \code{format = "json"}.}

\item{max_cols}{The maximum number of columns to show in the data frame. Only
applies when \code{format = "json"}.}

\item{package}{The name of the package that provides the data set. If not
provided, \code{data_frame} must be loaded in the current environment, or may
also be inferred from the name of the data frame, e.g. \code{"dplyr::storms"}.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
A character vector containing a representation of the data frame.
Will error if the named data frame is not found in the environment.
}
\description{
Tool: Describe data frame
}
\examples{
btw_tool_env_describe_data_frame(mtcars)

}
\seealso{
\code{\link[=btw_this.data.frame]{btw_this.data.frame()}}, \code{\link[=btw_tools]{btw_tools()}}

Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_environment}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()},
\code{\link{btw_tool_ide_read_current_editor}()},
\code{\link{btw_tool_package_docs}},
\code{\link{btw_tool_search_packages}()},
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
