% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{cnorm.betabinomial1}
\alias{cnorm.betabinomial1}
\title{Fit a beta binomial regression model}
\usage{
cnorm.betabinomial1(
  age,
  score,
  n = NULL,
  weights = NULL,
  mu = 3,
  sigma = 3,
  control = NULL,
  scale = "T",
  plot = T
)
}
\arguments{
\item{age}{A numeric vector of predictor values (e.g., age).}

\item{score}{A numeric vector of response values.}

\item{n}{Number of items in the test, resp. maximum score to be achieved}

\item{weights}{A numeric vector of weights for each observation. Default is NULL (equal weights).}

\item{mu}{Integer specifying the degree of the polynomial for the mean model. Default is 2.}

\item{sigma}{Integer specifying the degree of the polynomial for the standard deviation model. Default is 1.}

\item{control}{A list of control parameters to be passed to the `optim` function.
If NULL, default values are used.}

\item{scale}{type of norm scale, either T (default), IQ, z or percentile (= no
transformation); a double vector with the mean and standard deviation can as
well, be provided f. e. c(10, 3) for Wechsler scale index points}

\item{plot}{Logical indicating whether to plot the model. Default is TRUE.}
}
\value{
A list of class "cnormBetaBinomial" containing:
  \item{beta_est}{Estimated coefficients for the mean model}
  \item{gamma_est}{Estimated coefficients for the log-standard deviation model}
  \item{se}{Standard errors of the estimated coefficients}
  \item{mu}{Degree of the polynomial for the mean model}
  \item{sigma}{Degree of the polynomial for the standard deviation model}
  \item{result}{Full result from the optimization procedure}
}
\description{
This function fits a beta binomial regression model where both the mean and
standard deviation of the response variable are modeled as polynomial functions
of the predictor variable. While 'cnorm-betabinomial2' fits a beta-binomial model
on the basis of \eqn{\gamma} and \eqn{\beta} of a beta binomial function, this function
fits \eqn{\mu} and \eqn{\sigma}, which are then used to estimate the beta binomial distribution
parameters.
}
\details{
The function standardizes the input variables, fits polynomial models for both
the mean and standard deviation, and uses maximum likelihood estimation to
find the optimal parameters. The optimization is performed using the BFGS method.
}
\keyword{internal}
