% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdp_sdm.R
\name{pdp_sdm}
\alias{pdp_sdm}
\alias{get_pdp_sdm}
\title{Model Response to Variables}
\usage{
pdp_sdm(i, spp = NULL, algo = NULL, variables_selected = NULL, mean.only = FALSE)

get_pdp_sdm(i, spp = NULL, algo = NULL, variables_selected = NULL)
}
\arguments{
\item{i}{A \code{input_sdm} object.}

\item{spp}{A \code{character} vector with species names to obtain the PDPs. If \code{NULL}
(standard), the first species in \code{species_names(i)} is used.}

\item{algo}{A \code{character} containing the algorithm to obtain the PDP. If \code{NULL}
(standard) all algorithms are mixed.}

\item{variables_selected}{A \code{character}. If there is a subset of predictors that should be ploted in this, it
can be informed using this parameter.}

\item{mean.only}{Boolean. Should only the mean curve be plotted or a curve to each run should be
included? Standard is FALSE.}
}
\value{
A plot (for \code{pdp_sdm}) or a data.frame (for \code{get_pdp_sdm}) with PDP values.
}
\description{
Obtain the Partial Dependence Plots (PDP) to each variable.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="bioclim", n_set=3)

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "repeatedcv",
                                number = 2,
                                repeats = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")
# Train models:
i <- train_sdm(i, algo = c("naive_bayes"), ctrl=ctrl_sdm)
# PDP plots:
pdp_sdm(i)
get_pdp_sdm(i)

}
\seealso{
\code{\link{varImp_sdm}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
