% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pype_from_seurat.R
\name{pype_from_seurat}
\alias{pype_from_seurat}
\title{Convert Seurat to cellpypes object.}
\usage{
pype_from_seurat(seurat, graph_name = NULL)
}
\arguments{
\item{seurat}{A Seurat object.}

\item{graph_name}{Supply one of the graphs. To see options, type
\code{names(seurat@graphs)}. If left empty (\code{NULL}, the default),
\code{pype_from_seurat} will try to guess the correct name for you.}
}
\value{
A cellpypes object.
}
\description{
Start cellpyping a Seurat object.
This function saves the user from building his own cellpypes object,
which is done with \code{list(umi, neighbors,embed, totalUMI)}.
}
\section{cellpypes Objects}{

A cellpypes object is a \link[base]{list} with four slots:
\describe{
\item{\code{raw }}{(sparse) matrix with genes in rows, cells in columns}
\item{\code{totalUMI }}{the colSums of obj$raw}
\item{\code{embed }}{two-dimensional embedding of the cells, provided as data.frame
or tibble with two columns and one row per cell.}
\item{\code{neighbors }}{index matrix with one row per cell and k columns, where
k is the number of nearest neighbors (we recommend 15<k<100, e.g. k=50).
Here are two ways to get the neighbors index matrix:
\itemize{
\item Use \code{find_knn(featureMatrix)$idx}, where featureMatrix could be
principal components, latent variables or normalized genes (features in
rows, cells in columns).
\item use \code{as(seurat@graphs[["RNA_nn"]], "dgCMatrix")> .1} to extract
the kNN
graph computed on RNA. The \code{> .1} ensures this also works with RNA_snn,
wknn/wsnn or any other
available graph – check with \code{names(seurat@graphs)}.
}
}
}
}

