% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isbn-provider.R
\name{ISBNProvider}
\alias{ISBNProvider}
\title{ISBNProvider}
\description{
International Standard Book Number - Provider.
ISBN starts with group code, all English language ISBN-10 codes
start with a 0 or 1, and all German language books start with a 3.
see \url{https://en.wikipedia.org/wiki/List_of_ISBN_registration_groups}.

Charlatan does not provide further helpers for you, but you can supply the
prefix yourself, if for instance you want to create Mexican ISBNs you can
by supplying the ISBN10 prefix 970, or for Andorra supply the ISBN 13 prefix
97899920 (that is 978 for ISBN13, and 99920 for Andorra).
}
\examples{
z <- ISBNProvider$new()
z$isbn10()
z$isbn13()
z$isbn10(10)
z$isbn13(100)
# or even z$isbn10(500)
}
\section{Super class}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{ISBNProvider}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISBNProvider-isbn10}{\code{ISBNProvider$isbn10()}}
\item \href{#method-ISBNProvider-isbn13}{\code{ISBNProvider$isbn13()}}
\item \href{#method-ISBNProvider-clone}{\code{ISBNProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="print"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-print'><code>charlatan::BareProvider$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISBNProvider-isbn10"></a>}}
\if{latex}{\out{\hypertarget{method-ISBNProvider-isbn10}{}}}
\subsection{Method \code{isbn10()}}{
Make a ISBN10
This is a completely random (apart from the prefix), but valid ISBN10 number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISBNProvider$isbn10(n = 1, prefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of ISBN10s to make, default=1}

\item{\code{prefix}}{(integer/character) prefix for ISBN}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISBNProvider-isbn13"></a>}}
\if{latex}{\out{\hypertarget{method-ISBNProvider-isbn13}{}}}
\subsection{Method \code{isbn13()}}{
Make a ISBN13.
This is a completely random (apart from the prefix), but valid ISBN13 number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISBNProvider$isbn13(n = 1, prefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(integer) number of ISBN10s to make, default=1}

\item{\code{prefix}}{(integer/character) prefix for ISBN}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISBNProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISBNProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISBNProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
