% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{llm_api_call}
\alias{llm_api_call}
\title{Base LLM API Call Wrapper}
\usage{
llm_api_call(
  prompt_text,
  model = "gpt-3.5-turbo",
  api_key = "",
  top_p = 1,
  temp = 0
)
}
\arguments{
\item{prompt_text}{A character string containing the user prompt.}

\item{model}{A character string specifying the LLM model (default "gpt-3.5-turbo").}

\item{api_key}{API key as a character string.}

\item{top_p}{Numeric value for the probability mass (default 1).}

\item{temp}{Numeric value for the sampling temperature (default 0).}
}
\value{
A character string containing the LLM's response.
}
\description{
Sends a prompt (with background academic definitions) to an LLM API
(defaulting to 'OpenAI') and returns the LLM response.
}
\details{
The system prompt includes academic definitions for word frequency, lexical coverage,
Zipf's law, Levenshtein distance, and semantic transparency.
}
\examples{
\dontrun{
  response <- llm_api_call("Please provide a rating for the stimulus 'apple'.")
  cat(response)
}
}
