% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_question.R
\name{check_question}
\alias{check_question}
\title{Create check-fields and check-boxes for 'rmarkdown'}
\usage{
check_question(
  answer,
  right = "Correct",
  wrong = "I have a different answer",
  options = NULL,
  type = NULL,
  button_label = "check",
  alignment = NULL,
  placeholder = "",
  random_answer_order = FALSE,
  title = NULL,
  width_of_in_order = paste0(round(1/length(answer) * 85), "\%"),
  height_of_in_order = "60px",
  style_of_in_order = "padding:5px;border: 1px solid #aaaaaa; display: inline-block;",
  q_id = sample(1:1e+05, 1)
)
}
\arguments{
\item{answer}{correct answer (can be a double or a string). It is possible to put here a vector of several answers.}

\item{right}{form reaction on right answer}

\item{wrong}{form reaction on wrong answer}

\item{options}{vector of values for the selection list type}

\item{type}{character that defines type of the list. Possible values: \code{text}, \code{select}, \code{radio}, \code{checkbox}, \code{in_order}}

\item{button_label}{character value that will be displayed on the button}

\item{alignment}{character argument for options' alignment: \code{vertical} or \code{horizontal}}

\item{placeholder}{character that defines a short hint that describes the expected value of an input field. This works with the \code{text} input type only.}

\item{random_answer_order}{logical argument that denotes whether answers should be shuffled, when the \code{type} value is \code{select}, \code{radio} or \code{checkbox}}

\item{title}{character value that will be displayed as a question title. It is possible to put there the question. You can put markdown markup. Since this argument wraps the form contents with \code{fieldset} tags, you can redefine it appearance with CSS.}

\item{width_of_in_order}{character with some values for width of the boxes, when the \code{type} value is \code{in_order}. Possible values: "30px", "20\%"}

\item{height_of_in_order}{character with some values for height of the boxes, when the \code{type} value is \code{in_order}. Possible values: "30px", "20\%"}

\item{style_of_in_order}{character that contains CSS style for the \code{div} boxes, when the \code{type} value is \code{in_order}}

\item{q_id}{unique identifier of the question}
}
\value{
returns the html tags and javascript code
}
\description{
Create check-fields and check-boxes for 'rmarkdown'
}
\examples{

check_question(answer = 5)

}
\author{
George Moroz <agricolamz@gmail.com>
}
