# Generated by extendr: Do not edit by hand

# nolint start

#
# This file was created with the following call:
#   .Call("wrap__make_ciflyr_wrappers", use_symbols = TRUE, package_name = "ciflyr")

#' @usage NULL
#' @useDynLib ciflyr, .registration = TRUE
NULL

#' Perform the CIfly algorithm specified in the passed ruletable.
#'
#' For the given graph and sets, a CIfly reachability algorithm is run according to the ruletable specified in the ruletable argument. The algorithm returns all reachable nodes. It is guaranteed to run in linear-time.
#'
#' @param graph A list mapping edge types to edge lists stored in matrix format.
#' @param sets A list mapping set names to a list of elements.
#' @param ruletable Path to a ruletable file.
#' @param tableAsString Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.
#' @param verbose Optional argument to enable logging. Default value is FALSE.
#' @return A vector of all reachable nodes.
#' @examples
#' dsepTable <- "
#'     EDGES --> <--
#'     SETS X, Z
#'     START <-- AT X
#'     OUTPUT ...
#'     --> | <-- | current in Z
#'     ... | ... | current not in Z
#' "
#'
#' edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))
#' sets <- list("X" = c(1), "Z" = c(4))
#' reach(edgelist, sets, dsepTable, tableAsString=TRUE)
#' @export
reach <- function(graph, sets, ruletable, tableAsString = FALSE, verbose = FALSE) .Call(wrap__reach, graph, sets, ruletable, tableAsString, verbose)

#' Obtain an internal representation of a CIfly ruletable.
#'
#' Obtain an internal representation of a CIfly ruletable. Advanced usage only, mostly recommended for improving performance if the same ruletable is used multiple times. The parsed ruletable object can be passed to all methods with a ruletable argument.
#'
#' @param ruletable Path to a ruletable file.
#' @param tableAsString Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.
#' @return Internal CIfly ruletable representation.
#' @examples
#' dsepTable <- "
#'     EDGES --> <--
#'     SETS X, Z
#'     START <-- AT X
#'     OUTPUT ...
#'     --> | <-- | current in Z
#'     ... | ... | current not in Z
#' "
#'
#' rt <- parseRuletable(dsepTable, tableAsString=TRUE)
#' edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))
#' sets <- list("X" = c(1), "Z" = c(4))
#' reach(edgelist, sets, rt)
#' @export
parseRuletable <- function(ruletable, tableAsString = FALSE) .Call(wrap__parseRuletable, ruletable, tableAsString)

#' Obtain an internal representation of a CIfly graph.
#'
#' Obtain an internal representation of a CIfly graph. Advanced usage only, mostly recommended for improving performance if the same graph is used multiple times. The parsed graph object can be passed to all methods with a graph argument. It is compatible with all ruletables that have the same `EDGES ...` line as the ruletable passed as argument.
#'
#' @param graph A list mapping edge types to edge lists.
#' @param ruletable Path to a ruletable file.
#' @param tableAsString Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.
#' @return Internal CIfly graph representation.
#' @examples
#' dsepTable <- "
#'     EDGES --> <--
#'     SETS X, Z
#'     START <-- AT X
#'     OUTPUT ...
#'     --> | <-- | current in Z
#'     ... | ... | current not in Z
#' "
#' edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))
#'
#' g <- parseGraph(edgelist, dsepTable, tableAsString=TRUE)
#' sets <- list("X" = c(1), "Z" = c(4))
#' reach(edgelist, sets, dsepTable, tableAsString=TRUE)
#' @export
parseGraph <- function(graph, ruletable, tableAsString = FALSE) .Call(wrap__parseGraph, graph, ruletable, tableAsString)

#' Obtain an internal representation of CIfly sets.
#'
#' Obtain an internal representation of CIfly sets. Advanced usage only, mostly recommended for improving performance if the same sets are used multiple times. The parsed sets object can be passed to all methods with a sets argument. It is compatible with all ruletables that have the same `SETS ...` line as the ruletable passed as argument.
#'
#' @param sets A list mapping set names to a list of elements.
#' @param ruletable Path to a ruletable file.
#' @param tableAsString Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.
#' @return Internal CIfly sets representation.
#' @examples
#' dsepTable <- "
#'     EDGES --> <--
#'     SETS X, Z
#'     START <-- AT X
#'     OUTPUT ...
#'     --> | <-- | current in Z
#'     ... | ... | current not in Z
#' "
#' sets <- list("X" = c(1), "Z" = c(4))
#'
#' s <- parseSets(sets, dsepTable, tableAsString=TRUE)
#' edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))
#' reach(edgelist, s, dsepTable, tableAsString=TRUE)
#' @export
parseSets <- function(sets, ruletable, tableAsString = FALSE) .Call(wrap__parseSets, sets, ruletable, tableAsString)

Ruletable <- new.env(parent = emptyenv())

#' @export
`$.Ruletable` <- function (self, name) { func <- Ruletable[[name]]; environment(func) <- environment(); func }

#' @export
`[[.Ruletable` <- `$.Ruletable`

Graph <- new.env(parent = emptyenv())

#' @export
`$.Graph` <- function (self, name) { func <- Graph[[name]]; environment(func) <- environment(); func }

#' @export
`[[.Graph` <- `$.Graph`

Sets <- new.env(parent = emptyenv())

#' @export
`$.Sets` <- function (self, name) { func <- Sets[[name]]; environment(func) <- environment(); func }

#' @export
`[[.Sets` <- `$.Sets`


# nolint end
