% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyreg-methods.R
\name{polyreg-methods}
\alias{polyreg-methods}
\alias{coef.polyreg}
\alias{vcov.polyreg}
\alias{nobs.polyreg}
\alias{summary.polyreg}
\alias{print.summary.polyreg}
\alias{effect_label.polyreg}
\alias{tidy.polyreg}
\alias{glance.polyreg}
\alias{augment.polyreg}
\title{Methods for polyreg objects}
\usage{
\method{coef}{polyreg}(object, ...)

\method{vcov}{polyreg}(object, type = c("default", "sandwich", "bootstrap"), ...)

\method{nobs}{polyreg}(object, ...)

\method{summary}{polyreg}(object, ...)

\method{print}{summary.polyreg}(x, digits = 3, ...)

effect_label.polyreg(
  x,
  event = c("event1", "event2"),
  add.time.point = TRUE,
  add.outcome = TRUE,
  add.exposure.levels = TRUE,
  add.conf = TRUE,
  add.p = TRUE,
  value.time = NULL,
  unit.time = NULL,
  digits = 2,
  p_digits = 2,
  p_cut = 0.05,
  ...
)

\method{tidy}{polyreg}(x, event = c("event1", "event2", "both"), ...)

\method{glance}{polyreg}(x, event = c("event1", "event2"), ...)

\method{augment}{polyreg}(x, ...)
}
\arguments{
\item{object}{A polyreg object returned by \code{polyreg()}.}

\item{...}{Further arguments passed to or from methods.}

\item{type}{Character string; one of \code{"default"}, \code{"sandwich"},
or \code{"bootstrap"}. When \code{"default"}, the function chooses between
sandwich and bootstrap variance based on the original \code{polyreg()}
settings, using \code{outcome.type}, \code{report.sandwich.conf}, and
\code{report.boot.conf}. (Used only by \code{vcov.polyreg()}.)}

\item{x}{Object to be printed or summarised. Typically a
\code{"summary.polyreg"} object for \code{print.summary.polyreg()}, or
a \code{"polyreg"} object for \code{tidy.polyreg()}, \code{glance.polyreg()},
\code{augment.polyreg()}, and \code{effect_label.polyreg()}.}

\item{digits}{Number of digits to print for parameter estimates
or effect measures. Used by \code{print.summary.polyreg()} and
\code{effect_label.polyreg()}.}

\item{event}{Character string indicating which event to extract.
For \code{effect_label.polyreg()} and \code{glance.polyreg()} this is
one of \code{"event1"} or \code{"event2"}. For \code{tidy.polyreg()} it can
also be \code{"both"} to return rows for all events.}

\item{add.time.point}{Logical; if \code{TRUE}, \code{effect_label.polyreg()}
appends the time point to the label (e.g., “at 5 years”).}

\item{add.outcome}{Logical; if \code{TRUE}, \code{effect_label.polyreg()}
appends the outcome/event description (e.g., “of event 1”).}

\item{add.exposure.levels}{Logical; if \code{TRUE}, \code{effect_label.polyreg()}
includes the exposure level in the label (e.g., treatment group).}

\item{add.conf}{Logical; if \code{TRUE}, \code{effect_label.polyreg()}
includes a confidence interval in the label.}

\item{add.p}{Logical; if \code{TRUE}, \code{effect_label.polyreg()}
includes a p-value or thresholded p-value (e.g. p < 0.05).}

\item{value.time}{Optional numeric value overriding the time point
stored in the \code{"polyreg"} object when constructing labels in
\code{effect_label.polyreg()}.}

\item{unit.time}{Optional character string giving the time unit
to display in labels constructed by \code{effect_label.polyreg()},
such as \code{"years"} or \code{"months"}.}

\item{p_digits}{Integer; number of digits used to format p-values
in \code{effect_label.polyreg()}.}

\item{p_cut}{Numeric threshold used by \code{effect_label.polyreg()}
to decide between printing \code{p < p_cut} and an exact p-value.}
}
\value{
\itemize{
\item \code{coef.polyreg()} returns a numeric vector of regression
coefficients.
\item \code{vcov.polyreg()} returns a variance-covariance matrix.
\item \code{nobs.polyreg()} returns the number of observations.
\item \code{summary.polyreg()} returns a list of tidy and glance
summaries by event.
\item \code{print.summary.polyreg()} is called for its side effect
of printing a formatted, modelsummary-like table to the
console and returns \code{x} invisibly.
\item \code{tidy.polyreg()} returns a data frame of tidy coefficients
by event.
\item \code{glance.polyreg()} returns a data frame of model-level
summaries by event.
\item \code{augment.polyreg()} returns an augmented data frame
containing diagnostics, weights, and predicted CIFs.
}
}
\description{
S3 methods to extract coefficients, variance-covariance matrix,
sample size, formatted summaries, and tidy/glance/augment
from objects returned by \code{polyreg()}.
}
\seealso{
\code{\link[=polyreg]{polyreg()}} for log odds product modeling of CIFs
}
