% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{new_build}
\alias{new_build}
\title{Trigger a New Build on Circle CI}
\usage{
new_build(
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh",
  branch = "master",
  quiet = FALSE
)
}
\arguments{
\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}

\item{vcs_type}{\verb{[character]}\cr The version control system to use.
Defaults to "gh" (Github).}

\item{branch}{A character string specifying the repository branch.}

\item{quiet}{\verb{[logical]}\cr
If \code{TRUE}, console output is suppressed.}
}
\value{
An object of class \code{circle_api} with the following elements
\itemize{
\item \code{content} (queried content)
\item \code{path} (API request)
\item \code{response} (HTTP response information)
}
}
\description{
Triggers a new build for a specific repo branch.
}
\details{
Trigger a new Circle CI build for a specific repo branch.
}
\examples{
\dontrun{
new_build()
}
}
\seealso{
\code{\link[=retry_workflow]{retry_workflow()}}
}
