% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gamma}
\alias{gamma}
\title{Gamma Distribution for Prior Specification}
\usage{
gamma(alpha, beta)
}
\arguments{
\item{alpha}{Shape parameter of the gamma distribution. Must be positive.}

\item{beta}{Rate parameter of the gamma distribution. Must be positive.}
}
\value{
An object of class \code{"clm_dist"} representing a gamma distribution.
}
\description{
Creates a gamma distribution object for use with \code{\link[=prior]{prior()}}.
}
\note{
This function masks \code{base::gamma()}. To use the base gamma function,
use \code{base::gamma()} explicitly.
}
\examples{
# Create a gamma prior
gamma(2, 0.1)

# Use with prior() for degrees of freedom
prior(gamma(2, 0.1), class = "df")
}
\seealso{
\code{\link[=prior]{prior()}}, \code{\link[=normal]{normal()}}, \code{\link[=student_t]{student_t()}}, \code{\link[=cauchy]{cauchy()}}
}
