% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{preProcess_crop}
\alias{preProcess_crop}
\title{Remove observations from the exterior of interior of a breech face scan}
\usage{
preProcess_crop(x3p, region = "exterior", offset = 0, ...)
}
\arguments{
\item{x3p}{an x3p object containing the surface matrix of a cartridge case
scan}

\item{region}{dictates whether the observations on the "exterior" or
"interior" of the scan are removed}

\item{offset}{an integer (positive or negative) value to add to the estimated
radius of the associated region}

\item{...}{internal usage}
}
\value{
An x3p object containing the surface matrix of a breech face
impression scan where the observations on the exterior/interior of the
breech face scan surface.
}
\description{
Remove observations from the exterior of interior of a breech face scan
}
\examples{

#Process fadul1.1 "from scratch" (takes > 5 seconds to run)
\dontrun{
nbtrd_link <- "https://tsapps.nist.gov/NRBTD/Studies/CartridgeMeasurement/"
fadul1.1_link <- "DownloadMeasurement/2d9cc51f-6f66-40a0-973a-a9292dbee36d"

fadul1.1 <- x3ptools::read_x3p(paste0(nbtrd_link,fadul1.1_link))

fadul1.1_extCropped <- preProcess_crop(x3p = fadul1.1,
                                       radiusOffset = -30,
                                       region = "exterior")

fadul1.1_extIntCropped <- preProcess_crop(x3p = fadul1.1_extCropped,
                                          radiusOffset = 200,
                                          region = "interior")

x3pListPlot(list("Original" = fadul1.1,
                 "Exterior Cropped" = fadul1.1_extCropped,
                 "Exterior & Interior Cropped" = fadul1.1_extIntCropped ))
}
}
