% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order_collinear.R
\name{preference_order_collinear}
\alias{preference_order_collinear}
\title{Preference Order Argument in collinear()}
\usage{
preference_order_collinear(
  df = NULL,
  response = NULL,
  predictors = NULL,
  preference_order = NULL,
  f = NULL,
  quiet = FALSE
)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional; character string or vector) Name/s of response variable/s in \code{df}. Used in target encoding when it names a numeric variable and there are categorical predictors, and to compute preference order. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{preference_order}{(optional; string, character vector, output of \code{\link[=preference_order]{preference_order()}}). Defines a priority order, from first to last, to preserve predictors during the selection process. Accepted inputs are:
\itemize{
\item \strong{"auto"} (default): if \code{response} is not NULL, calls \code{\link[=preference_order]{preference_order()}} for internal computation.
\item \strong{character vector}: predictor names in a custom preference order.
\item \strong{data frame}: output of \code{\link[=preference_order]{preference_order()}} from \code{response} of length one.
\item \strong{named list}: output of \code{\link[=preference_order]{preference_order()}} from \code{response} of length two or more.
\item \strong{NULL}: disabled.
}. Default: "auto"}

\item{f}{(optional: function) Function to compute preference order. If "auto" (default) or NULL, the output of \code{\link[=f_auto]{f_auto()}} for the given data is used:
\itemize{
\item \code{\link[=f_auc_rf]{f_auc_rf()}}: if \code{response} is binomial.
\item \code{\link[=f_r2_pearson]{f_r2_pearson()}}: if \code{response} and \code{predictors} are numeric.
\item \code{\link[=f_v]{f_v()}}: if \code{response} and \code{predictors} are categorical.
\item \code{\link[=f_v_rf_categorical]{f_v_rf_categorical()}}: if \code{response} is categorical and \code{predictors} are numeric or mixed .
\item \code{\link[=f_r2_rf]{f_r2_rf()}}: in all other cases.
}
Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
character vector or NULL
}
\description{
Internal function to manage the argument \code{preference_order} in \code{\link[=collinear]{collinear()}}.
}
\seealso{
Other preference_order_tools: 
\code{\link{f_auto}()},
\code{\link{f_auto_rules}()},
\code{\link{f_functions}()}
}
\concept{preference_order_tools}
