% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional.R
\name{adjust_LD}
\alias{adjust_LD}
\title{adjust LD for variable sample size}
\usage{
adjust_LD(S, LD)
}
\arguments{
\item{S}{coloc style dataset, with additional entries n0  and n1  which are *vectors* giving the number of cases and controls genotyped at each SNP}

\item{LD}{matrix of LD, with dimnames given by snps in S$snp}
}
\value{
adjusted LD matrix
}
\description{
adjust LD for variable sample size
}
\examples{
library(coloc)

data(coloc_test_data)
attach(coloc_test_data)
LD=D1$LD
dimnames(LD)=list(D1$snp,D1$snp)
D1$type="cc"
D1$s=.5
D1$n1=D1$N * sample(c(0.25,.5),length(D1$snp), replace=TRUE)
D1$n0=rep(0.5*D1$N,length(D1$snp))
aLD=colocPropTest::adjust_LD(D1,LD)
LD[1:6,1:6]
aLD[1:6,1:6]
detach(coloc_test_data)
}
