% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMatrix.R
\name{CMImat2mat}
\alias{CMImat2mat}
\title{Normalized Conditional Mutual Information Between Two Matrices}
\usage{
CMImat2mat(mat1, mat2, condi, bin = 6, sp_order = 2)
}
\arguments{
\item{mat1}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{mat2}{Another numeric matrix to compare against. Must have the same dimensions as `mat1`.}

\item{condi}{A numeric condition vector, matching the number of columns in `mat1`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric vector representing the normalized conditional mutual information (CMI) between pairs of rows
from `mat1` and `mat2`, conditioned on `condi`.
}
\description{
Computes the normalized conditional mutual information (CMI) between corresponding rows of two matrices,
given a condition variable, normalized by their individual information content. CMI is calculated using the specified number of bins and spline order.
}
\examples{
mat1 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
mat2 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
condi <- rnorm(100)
CMImat2mat(mat1, mat2, condi)

}
