% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_helmert.R
\name{reverse_helmert_code}
\alias{reverse_helmert_code}
\title{Reverse Helmert code}
\usage{
reverse_helmert_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
Reverse helmert coding is the same concept as helmert coding, but the order
of the groupings is reversed. See also \link[contrastable]{helmert_code}.
}
\details{
Reverse helmert coding compares each level to the total mean of all levels
that come after it. Differs from forward difference coding, which only
compares pairs of levels (not a level to a cumulative mean of levels).

Example interpretation for a 4 level factor:
\itemize{
\item Intercept = Grand mean (mean of the means of each level)
\item grp1 = mean(grp4, grp3, grp2) - grp(1)
\item grp2 = mean(grp4, grp3) - mean(grp2)
\item grp3 = mean(grp3) - mean(grp4)
}
}
\examples{

mydf <- data.frame(
  grp = gl(4,5),
  resp = c(seq(1, 5), seq(5, 9), seq(10, 14), seq(15, 19))
)

mydf <- set_contrasts(mydf, grp ~ reverse_helmert_code)
lm(resp ~ grp, data = mydf)
}
