% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armed_bandit_helpers.R
\name{get_betas}
\alias{get_betas}
\title{Generate Reward Parameters for Simulated Linear Bandits}
\usage{
get_betas(simulations, d, k)
}
\arguments{
\item{simulations}{Integer. Number of simulations.}

\item{d}{Integer. Number of features (context dimensions).}

\item{k}{Integer. Number of arms.}
}
\value{
A list of length \code{simulations + 1} (first element being discarded in the underlying
simulation package), each containing a \code{d x k} matrix of normalized reward parameters.
}
\description{
Creates a list of matrices representing the arm-specific reward-generating parameters (betas)
used in contextual linear bandit simulations. Each matrix corresponds to one simulation
and contains normalized random coefficients.
}
